\name{pasi_score}
\alias{pasi_score}
\title{
Psoriasis Area and Severity Index (PASI)
}
\description{
Calculates the PASI score to assess the severity of psoriasis. The body is divided into four sections (Head, Arms, Trunk, Legs). Each section is scored for the severity of erythema, induration, and desquamation (0-4), and the percentage of area affected. The final score ranges from 0 to 72.
}
\usage{
pasi_score(head_erythema, head_induration, head_desquamation, head_area_percent,
           arms_erythema, arms_induration, arms_desquamation, arms_area_percent,
           trunk_erythema, trunk_induration, trunk_desquamation, trunk_area_percent,
           legs_erythema, legs_induration, legs_desquamation, legs_area_percent)
}
\arguments{
  \item{head_erythema}{Numeric (0-4). Severity of redness on the head.}
  \item{head_induration}{Numeric (0-4). Severity of thickness on the head.}
  \item{head_desquamation}{Numeric (0-4). Severity of scaling on the head.}
  \item{head_area_percent}{Numeric (0-100). Percentage of head area affected.}
  \item{arms_erythema}{Numeric (0-4). Severity of redness on upper limbs.}
  \item{arms_induration}{Numeric (0-4). Severity of thickness on upper limbs.}
  \item{arms_desquamation}{Numeric (0-4). Severity of scaling on upper limbs.}
  \item{arms_area_percent}{Numeric (0-100). Percentage of upper limb area affected.}
  \item{trunk_erythema}{Numeric (0-4). Severity of redness on the trunk.}
  \item{trunk_induration}{Numeric (0-4). Severity of thickness on the trunk.}
  \item{trunk_desquamation}{Numeric (0-4). Severity of scaling on the trunk.}
  \item{trunk_area_percent}{Numeric (0-100). Percentage of trunk area affected.}
  \item{legs_erythema}{Numeric (0-4). Severity of redness on lower limbs.}
  \item{legs_induration}{Numeric (0-4). Severity of thickness on lower limbs.}
  \item{legs_desquamation}{Numeric (0-4). Severity of scaling on lower limbs.}
  \item{legs_area_percent}{Numeric (0-100). Percentage of lower limb area affected.}
}
\details{
\strong{Severity Scores:}
0: None
1: Mild
2: Moderate
3: Severe
4: Very Severe

\strong{Area Scoring (Internal Conversion):}
0\%: 0
<10\%: 1
10-29\%: 2
30-49\%: 3
50-69\%: 4
70-89\%: 5
90-100\%: 6
}
\value{
A list containing:
\item{PASI_Score}{The calculated total score.}
\item{Interpretation}{General severity classification (Mild <=5, Moderate 5-10, Severe >10).}
\item{Subscores}{Breakdown of weighted scores by body region.}
}
\references{
Fredriksson T, Pettersson U. Severe psoriasis--oral therapy with a new retinoid. Dermatologica. 1978;157(4):238-244. doi:10.1159/000250825
}
\examples{

# Example 1: Severe Psoriasis
# Head: 2,2,2, 50% | Arms: 3,3,3, 60% | Trunk: 2,2,2, 40% | Legs: 4,4,4, 80%
pasi_score(2,2,2,50, 3,3,3,60, 2,2,2,40, 4,4,4,80)

# Example 2: Mild Psoriasis
# Head: 1,0,1, 5% | Arms: 1,1,0, 5% | Trunk: 0,0,0, 0% | Legs: 1,1,1, 10%
pasi_score(1,0,1,5, 1,1,0,5, 0,0,0,0, 1,1,1,10)
}
