\name{paradise_criteria_tonsillectomy}
\alias{paradise_criteria_tonsillectomy}
\title{
Paradise Criteria for Tonsillectomy in Children
}
\description{
Evaluates the Paradise criteria to determine the appropriateness of tonsillectomy in children with recurrent throat infections. The criteria require a specific frequency of episodes over 1 to 3 years, and each episode must be characterized by specific clinical features (fever, lymphadenopathy, exudate, or positive GABHS) and treated with antibiotics.
}
\usage{
paradise_criteria_tonsillectomy(episodes_past_12_months,
                                episodes_per_year_last_2_years,
                                episodes_per_year_last_3_years,
                                clinical_features_confirmed,
                                antibiotics_given_documented)
}
\arguments{
  \item{episodes_past_12_months}{
Numeric. Number of throat infection episodes in the past year. (Threshold: >= 7).
}
  \item{episodes_per_year_last_2_years}{
Numeric. Average number of throat infection episodes per year for the past 2 years. (Threshold: >= 5 per year).
}
  \item{episodes_per_year_last_3_years}{
Numeric. Average number of throat infection episodes per year for the past 3 years. (Threshold: >= 3 per year).
}
  \item{clinical_features_confirmed}{
Numeric (0 or 1). Did each episode include at least one of the following: Temperature > 38.3 C (100.9 F), cervical lymphadenopathy (>2cm or tender), tonsillar exudate, or positive GABHS culture? (1 = Yes).
}
  \item{antibiotics_given_documented}{
Numeric (0 or 1). Were the episodes treated with antibiotics and documented in clinical records? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding tonsillectomy ("Criteria Met" or "Criteria Not Met").}
}
\references{
Paradise JL, Bluestone CD, Bachman RZ, et al. Efficacy of tonsillectomy for recurrent throat infection in severely affected children. Results of parallel randomized and nonrandomized clinical trials. N Engl J Med. 1984;310(11):674-683. doi:10.1056/NEJM198403153101102
}
\examples{

# Example 1: Criteria Met (7 in 1 year)
# 7 episodes, features present, documented
paradise_criteria_tonsillectomy(7, 0, 0, 1, 1)

# Example 2: Criteria Not Met (Frequency insufficient)
# 4 episodes in 1 year, features present
paradise_criteria_tonsillectomy(4, 0, 0, 1, 1)

# Example 3: Criteria Not Met (Clinical features missing)
# 8 episodes, but not characterized by fever/nodes/exudate
paradise_criteria_tonsillectomy(8, 0, 0, 0, 1)
}
