\name{novel_pneumonia_risk_score}
\alias{novel_pneumonia_risk_score}
\title{
Novel Pneumonia Risk Score (PRS)
}
\description{
Calculates the Novel Pneumonia Risk Score (PRS) to estimate the risk of developing community-acquired pneumonia in primary care patients. The score is based on age, sex, comorbidities (heart failure, COPD, epilepsy, Parkinson's), history of pneumonia, and current medication use (PPIs, opioids).
}
\usage{
novel_pneumonia_risk_score(age, sex, heart_failure, copd, epilepsy,
                           parkinsons, previous_pneumonia, current_ppi_use,
                           current_opioid_use)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Score adds Age / 10).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds 1 point).
}
  \item{heart_failure}{
Numeric (0 or 1). History of heart failure. (1 = Yes, +1 point).
}
  \item{copd}{
Numeric (0 or 1). History of COPD. (1 = Yes, +1 point).
}
  \item{epilepsy}{
Numeric (0 or 1). History of epilepsy. (1 = Yes, +1 point).
}
  \item{parkinsons}{
Numeric (0 or 1). History of Parkinson's disease. (1 = Yes, +1 point).
}
  \item{previous_pneumonia}{
Numeric (0 or 1). History of previous pneumonia (within the last 3 years). (1 = Yes, +3 points).
}
  \item{current_ppi_use}{
Numeric (0 or 1). Current use of Proton Pump Inhibitors (PPIs). (1 = Yes, +2 points).
}
  \item{current_opioid_use}{
Numeric (0 or 1). Current use of opioids. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{PRS_Score}{The calculated risk score.}
\item{Risk_Category}{Classification (Low < 10, Medium 10-15, High > 15).}
}
\references{
Hamilton F, et al. A simple clinical risk score to predict the risk of pneumonia in primary care. Eur Respir J. 2019.
}
\examples{

# Example 1: Low Risk
# 50yo Female, No comorbidities
# Score = 5.0
novel_pneumonia_risk_score(50, "female", 0, 0, 0, 0, 0, 0, 0)

# Example 2: High Risk
# 75yo Male (+8.5), COPD (+1), Prev Pneumonia (+3), PPI (+2)
# Score = 7.5 + 1 + 1 + 3 + 2 = 14.5 (Medium/High border)
novel_pneumonia_risk_score(75, "male", 0, 1, 0, 0, 1, 1, 0)
}
