\name{isaric_4c_mortality}
\alias{isaric_4c_mortality}
\title{
4C Mortality Score for COVID-19
}
\description{
Calculates the ISARIC 4C Mortality Score to predict in-hospital mortality risk for patients admitted with COVID-19. This score was derived from a large UK cohort and outperforms many other risk stratification tools. It assigns patients to Low, Intermediate, High, or Very High risk groups.
}
\usage{
isaric_4c_mortality(age, sex, comorbidities, resp_rate, o2_sat, gcs,
                    urea, crp, urea_units = "mmol/L", crp_units = "mg/L")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Biological sex ("Male" or "Female").
}
  \item{comorbidities}{
Numeric. Number of relevant comorbidities (0, 1, or >=2).
Relevant comorbidities include: Chronic cardiac disease, chronic respiratory disease (excluding asthma), chronic renal disease (eGFR <= 30), mild-severe liver disease, dementia, chronic neurological conditions, connective tissue disease, diabetes.
}
  \item{resp_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{o2_sat}{
Numeric. Peripheral oxygen saturation (\%) on room air.
}
  \item{gcs}{
Numeric. Glasgow Coma Scale score (3-15).
}
  \item{urea}{
Numeric. Serum Urea or BUN level.
}
  \item{crp}{
Numeric. C-Reactive Protein level.
}
  \item{urea_units}{
String. Units for the urea input. Options: "mmol/L" (default) or "mg/dL" (treats input as Blood Urea Nitrogen/BUN).
}
  \item{crp_units}{
String. Units for the CRP input. Options: "mg/L" (default) or "mg/dL".
}
}
\value{
A list containing:
\item{Total_Score}{The calculated 4C Mortality Score (Range 0-21).}
\item{Risk_Group}{Risk classification (Low, Intermediate, High, Very High).}
\item{Est_In_Hospital_Mortality}{Estimated mortality percentage based on the validation cohort.}
\item{Recommendation}{Clinical management suggestion.}
}
\references{
Knight SR, et al. Risk stratification of patients admitted to hospital with covid-19 using the ISARIC WHO Clinical Characterisation Protocol: development and validation of the 4C Mortality Score. BMJ. 2020;370:m3339. doi:10.1136/bmj.m3339
}
\examples{

# Example 1: High Risk Patient
# 75yo Male, 2 comorbidities, RR 22, O2 91\%, GCS 15, High Urea/CRP
isaric_4c_mortality(
  age = 75, sex = "male", comorbidities = 2,
  resp_rate = 22, o2_sat = 91, gcs = 15,
  urea = 15, crp = 120, urea_units = "mmol/L", crp_units = "mg/L"
)

# Example 2: Low Risk Patient
# 45yo Female, 0 comorbidities, Normal vitals and labs
isaric_4c_mortality(
  age = 45, sex = "female", comorbidities = 0,
  resp_rate = 16, o2_sat = 98, gcs = 15,
  urea = 4, crp = 10, urea_units = "mmol/L", crp_units = "mg/L"
)
}
