\name{hiet_dosing}
\alias{hiet_dosing}
\title{
High-Dose Insulin Euglycemia Therapy (HIET) Dosing
}
\description{
Calculates the initial dosing for High-Dose Insulin Euglycemia Therapy (HIET), used in the management of severe Calcium Channel Blocker (CCB) and Beta Blocker (BB) toxicity. The protocol includes an insulin bolus and infusion to improve cardiac contractility, alongside dextrose supplementation to maintain euglycemia.
}
\usage{
hiet_dosing(weight_kg, serum_glucose_initial, insulin_bolus_dose_u_kg = 1,
            insulin_drip_rate_u_kg_hr = 0.5, dextrose_bolus_g_kg = 0.5,
            dextrose_drip_g_kg_hr = 0.5)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{serum_glucose_initial}{
Numeric. Initial serum glucose level in mg/dL. Used to determine if a Dextrose bolus is required (glucose < 200 mg/dL).
}
  \item{insulin_bolus_dose_u_kg}{
Numeric. Bolus dose of Regular Insulin in Units/kg. Defaults to 1 U/kg.
}
  \item{insulin_drip_rate_u_kg_hr}{
Numeric. Infusion rate of Regular Insulin in Units/kg/hr. Defaults to 0.5 U/kg/hr.
}
  \item{dextrose_bolus_g_kg}{
Numeric. Bolus dose of Dextrose (e.g., D50) in g/kg. Administered only if initial glucose < 200 mg/dL. Defaults to 0.5 g/kg.
}
  \item{dextrose_drip_g_kg_hr}{
Numeric. Initial dextrose infusion rate in g/kg/hr. Defaults to 0.5 g/kg/hr.
}
}
\value{
A list containing:
\item{Insulin_Bolus_Units}{The calculated insulin bolus dose in Units.}
\item{Insulin_Drip_Units_hr}{The calculated insulin infusion rate in Units per hour.}
\item{Dextrose_Bolus_Grams}{The calculated dextrose bolus in grams (0 if glucose >= 200).}
\item{Dextrose_Maintenance_Grams_hr}{The calculated dextrose maintenance infusion rate in grams per hour.}
}
\references{
Greene SL, Gawarammana I, Wood DM, et al. Relative safety of hyperinsulinemia/euglycemia therapy in the management of calcium channel blocker overdose: a prospective observational study. Intensive Care Med. 2007;33(11):2019-2024. doi:10.1007/s00134-007-0792-8
}
\examples{

# Example 1: Hypoglycemic/Euglycemic patient (Glucose 150)
# 70kg patient
# Insulin Bolus: 70 U, Drip: 35 U/hr
# Dextrose Bolus: 35g, Drip: 35g/hr
hiet_dosing(70, 150)

# Example 2: Hyperglycemic patient (Glucose 250)
# 80kg patient
# Insulin Bolus: 80 U, Drip: 40 U/hr
# Dextrose Bolus: 0g (Skipped), Drip: 40g/hr
hiet_dosing(80, 250)
}
