\name{gleason_score_calculator}
\alias{gleason_score_calculator}
\title{
Gleason Score and ISUP Grade Group for Prostate Cancer
}
\description{
Calculates the Total Gleason Score and the corresponding International Society of Urological Pathology (ISUP) Prognostic Grade Group. The score is derived from the two most prevalent histologic patterns of the tumor, graded 1 to 5.
}
\usage{
gleason_score_calculator(primary_grade, secondary_grade)
}
\arguments{
  \item{primary_grade}{
Numeric (1-5). The histologic pattern that is most prevalent in the biopsy sample.
}
  \item{secondary_grade}{
Numeric (1-5). The histologic pattern that is the second most prevalent in the biopsy sample.
}
}
\value{
A list containing:
\item{Total_Gleason_Score}{The sum of the primary and secondary grades (Range 2-10).}
\item{ISUP_Grade_Group}{The prognostic grade group (1-5) based on the 2014 ISUP consensus.}
\item{Prognosis_Description}{Text description of the grade group.}
}
\references{
Epstein JI, Egevad L, Amin MB, et al. The 2014 International Society of Urological Pathology (ISUP) Consensus Conference on Gleason Grading of Prostatic Carcinoma. Am J Surg Pathol. 2016;40(2):244-252. doi:10.1097/PAS.0000000000000530
}
\examples{

# Example 1: Grade Group 1
# Primary 3, Secondary 3
gleason_score_calculator(3, 3)

# Example 2: Grade Group 2 (3+4)
# Primary 3, Secondary 4
gleason_score_calculator(3, 4)

# Example 3: Grade Group 3 (4+3)
# Primary 4, Secondary 3
gleason_score_calculator(4, 3)
}
