\name{gad7_anxiety_screen}
\alias{gad7_anxiety_screen}
\title{
GAD-7 (General Anxiety Disorder-7)
}
\description{
Calculates the GAD-7 score, a brief 7-item screening tool for Generalized Anxiety Disorder (GAD). It is also useful for screening Panic Disorder, Social Anxiety Disorder, and PTSD. Scores of 5, 10, and 15 represent cutpoints for mild, moderate, and severe anxiety, respectively.
}
\usage{
gad7_anxiety_screen(q1, q2, q3, q4, q5, q6, q7)
}
\arguments{
  \item{q1}{
Numeric (0-3). Feeling nervous, anxious, or on edge.
}
  \item{q2}{
Numeric (0-3). Not being able to stop or control worrying.
}
  \item{q3}{
Numeric (0-3). Worrying too much about different things.
}
  \item{q4}{
Numeric (0-3). Trouble relaxing.
}
  \item{q5}{
Numeric (0-3). Being so restless that it is hard to sit still.
}
  \item{q6}{
Numeric (0-3). Becoming easily annoyed or irritable.
}
  \item{q7}{
Numeric (0-3). Feeling afraid as if something awful might happen.
}
}
\details{
\strong{Scoring Key (Over the last 2 weeks):}
0 = Not at all
1 = Several days
2 = More than half the days
3 = Nearly every day
}
\value{
A list containing:
\item{GAD7_Score}{The calculated total score (Range 0-21).}
\item{Severity_Category}{Interpretation (Minimal, Mild, Moderate, Severe).}
\item{Screening_Result}{Clinical guidance based on the cutoff of 10.}
}
\references{
Spitzer RL, Kroenke K, Williams JB, Löwe B. A brief measure for assessing generalized anxiety disorder: the GAD-7. Arch Intern Med. 2006;166(10):1092-1097. doi:10.1001/archinte.166.10.1092
}
\examples{

# Example 1: Moderate Anxiety (Positive Screen)
# Mostly "More than half the days" (2)
gad7_anxiety_screen(2, 2, 1, 2, 1, 2, 1)

# Example 2: Minimal Anxiety (Negative Screen)
# Mostly "Not at all" (0)
gad7_anxiety_screen(0, 1, 0, 0, 0, 0, 0)
}
