\name{func_ich_score}
\alias{func_ich_score}
\title{
FUNC Score for ICH Functional Outcome
}
\description{
Calculates the FUNC Score to predict the probability of functional independence (GCS >= 4) at 90 days in patients with primary intracerebral hemorrhage (ICH). The score (0-11) evaluates ICH volume, age, location, GCS, and pre-ICH cognitive status. Higher scores indicate a better prognosis.
}
\usage{
func_ich_score(ich_volume_cm3, age, location, gcs, cognitive_impairment_pre_ich)
}
\arguments{
  \item{ich_volume_cm3}{
Numeric. Volume of the hematoma in cm^3 (often calculated via ABC/2 method).
<30: 4 pts.
30-60: 2 pts.
>60: 0 pts.
}
  \item{age}{
Numeric. Patient age in years.
<70: 2 pts.
70-79: 1 pt.
>=80: 0 pts.
}
  \item{location}{
String. Location of the hemorrhage. Options: "lobar" (2 pts), "deep" (1 pt), "infratentorial" (0 pts).
}
  \item{gcs}{
Numeric. Glasgow Coma Scale score on admission.
>=9: 2 pts.
<=8: 0 pts.
}
  \item{cognitive_impairment_pre_ich}{
Numeric (0 or 1). Presence of cognitive impairment prior to the ICH. (1 = Yes: 0 pts, 0 = No: 1 pt).
}
}
\value{
A list containing:
\item{FUNC_Score}{The calculated score (Range 0-11).}
\item{Prob_Functional_Independence_90_Day}{Estimated probability of achieving functional independence at 90 days.}
}
\references{
Rost NS, Smith EE, Chang Y, et al. Prediction of functional outcome in patients with primary intracerebral hemorrhage: the FUNC score. Stroke. 2008;39(8):2304-2309. doi:10.1161/STROKEAHA.107.512202
}
\examples{

# Example 1: Good Prognosis
# Vol 15 (<30 -> 4), Age 60 (<70 -> 2), Lobar (2), GCS 14 (2), No impairment (1)
# Score = 11
func_ich_score(15, 60, "lobar", 14, 0)

# Example 2: Poor Prognosis
# Vol 40 (30-60 -> 2), Age 82 (0), Deep (1), GCS 7 (0), Impairment Yes (0)
# Score = 3
func_ich_score(40, 82, "deep", 7, 1)
}
