\name{el_ganzouri_risk_index}
\alias{el_ganzouri_risk_index}
\title{
El-Ganzouri Risk Index (EGRI) for Difficult Airway
}
\description{
Calculates the El-Ganzouri Risk Index (EGRI) to estimate the probability of difficult tracheal intubation. The score ranges from 0 to 12, with a score of 4 or higher indicating a significant risk for difficult intubation.
}
\usage{
el_ganzouri_risk_index(mouth_opening_cm, thyromental_distance_cm, mallampati_score,
                       neck_movement_degrees, can_prognath, weight_kg,
                       history_difficult_intubation)
}
\arguments{
  \item{mouth_opening_cm}{
Numeric. Inter-incisor gap in centimeters. (>=4: 0 pts, <4: 1 pt).
}
  \item{thyromental_distance_cm}{
Numeric. Thyromental distance in centimeters. (>6.5: 0 pts, 6.0-6.5: 1 pt, <6.0: 2 pts).
}
  \item{mallampati_score}{
Numeric (1-4). Modified Mallampati Classification. (I-II: 0 pts, III: 1 pt, IV: 2 pts).
}
  \item{neck_movement_degrees}{
Numeric. Range of neck motion in degrees. (>90: 0 pts, 80-90: 1 pt, <80: 2 pts).
}
  \item{can_prognath}{
Numeric (0 or 1). Ability to protrude jaw (prognath). (1 = Yes: 0 pts, 0 = No: 1 pt).
}
  \item{weight_kg}{
Numeric. Patient body weight in kilograms. (<90: 0 pts, 90-110: 1 pt, >110: 2 pts).
}
  \item{history_difficult_intubation}{
String. History of difficult intubation. Options: "none" (0 pts), "questionable" (1 pt), "definite" (2 pts).
}
}
\value{
A list containing:
\item{EGRI_Score}{The calculated total score (Range 0-12).}
\item{Risk_Category}{Classification (Low Risk < 4, High Risk >= 4).}
}
\references{
El-Ganzouri AR, McCarthy RJ, Tuman KJ, Tanck EN, Ivankovich AD. Preoperative airway assessment: predictive value of a multivariate risk index. Anesth Analg. 1996;82(6):1197-1204. doi:10.1097/00000539-199606000-00017
}
\examples{

# Example 1: High Risk
# Small mouth, short TMD, Mallampati 3, limited neck, heavy, prior difficulty
# Score = 1 + 2 + 1 + 1 + 1 + 2 + 2 = 10
el_ganzouri_risk_index(3.5, 5.5, 3, 85, 0, 120, "definite")

# Example 2: Low Risk
# Normal anatomy
# Score = 0
el_ganzouri_risk_index(5, 8, 1, 100, 1, 70, "none")
}
