\name{cardiac_anesthesia_risk_evaluation}
\alias{cardiac_anesthesia_risk_evaluation}
\title{
Cardiac Anesthesia Risk Evaluation (CARE) Score
}
\description{
Calculates the CARE score to predict in-hospital mortality and morbidity after cardiac surgery. This score categorizes patients into one of five risk classes based on the presence of specific preoperative risk factors, prioritizing the most severe condition present.
}
\usage{
cardiac_anesthesia_risk_evaluation(history_cardiac_surgery, complex_surgery,
                                   uncontrolled_medical_condition, emergency_surgery)
}
\arguments{
  \item{history_cardiac_surgery}{
Numeric (0 or 1). Prior cardiac surgery. (1 = Yes). This assigns a base score of 2.
}
  \item{complex_surgery}{
Numeric (0 or 1). Surgery other than isolated CABG (e.g., valve, aortic, or combined procedures). (1 = Yes). This assigns a base score of 3.
}
  \item{uncontrolled_medical_condition}{
Numeric (0 or 1). Presence of uncontrolled medical conditions (e.g., active heart failure, acute MI <7 days, unstable angina). (1 = Yes). This assigns a base score of 4.
}
  \item{emergency_surgery}{
Numeric (0 or 1). Surgery required immediately to save life or limb. (1 = Yes). This assigns a base score of 5.
}
}
\details{
The scoring is hierarchical. A patient is assigned the highest score for which they meet the criteria:
Score 5: Emergency surgery.
Score 4: Uncontrolled medical condition (if not Emergency).
Score 3: Complex surgery (if not Emergency or Uncontrolled).
Score 2: Prior cardiac surgery (if not the above).
Score 1: Routine case (none of the above).
}
\value{
A list containing:
\item{CARE_Score}{The calculated risk class (1-5).}
\item{In_Hospital_Mortality_Risk}{Estimated mortality percentage.}
\item{Morbidity_Risk}{Estimated morbidity percentage (e.g., stroke, renal failure, prolonged ventilation).}
}
\references{
Dupuis JY, Wang F, Nathan H, et al. The cardiac anesthesia risk evaluation score: a clinically useful predictor of mortality and morbidity after cardiac surgery. Anesthesiology. 2001;94(2):194-204. doi:10.1097/00000542-200102000-00009
}
\examples{

# Example 1: Routine CABG (No risks)
# Score = 1
cardiac_anesthesia_risk_evaluation(0, 0, 0, 0)

# Example 2: Emergency Surgery
# Regardless of other factors, Emergency = Score 5
cardiac_anesthesia_risk_evaluation(1, 1, 1, 1)

# Example 3: Valve Surgery (Complex) with no other uncontrolled conditions
# Score = 3
cardiac_anesthesia_risk_evaluation(0, 1, 0, 0)
}
