\name{calculate_pregnancy_due_date}
\alias{calculate_pregnancy_due_date}
\title{
Pregnancy Due Dates Calculator
}
\description{
Calculates the Estimated Due Date (EDD) and current gestational age based on various clinical inputs. The calculator supports methods using the Last Menstrual Period (LMP), Date of Conception, or IVF Transfer dates (3-day or 5-day).
}
\usage{
calculate_pregnancy_due_date(input_date, method = "LMP", cycle_length = 28)
}
\arguments{
  \item{input_date}{
Date or String (YYYY-MM-DD). The reference date corresponding to the chosen method (e.g., the date of the LMP).
}
  \item{method}{
String. The method used for calculation. Options:
"LMP": Last Menstrual Period (Standard Naegele's Rule).
"Conception": Date of conception/ovulation.
"IVF_3_Day": Date of 3-day embryo transfer.
"IVF_5_Day": Date of 5-day embryo transfer.
}
  \item{cycle_length}{
Numeric. The length of the patient's menstrual cycle in days. Only applicable when method is "LMP". Defaults to 28.
}
}
\value{
A list containing:
\item{Estimated_Due_Date}{The calculated date of delivery (40 weeks).}
\item{Gestational_Age}{The current gestational age in weeks and days based on the system date.}
\item{Current_Trimester}{The current trimester (1st, 2nd, or 3rd).}
}
\references{
American College of Obstetricians and Gynecologists. Method for Estimating Due Date. Committee Opinion No. 700. Obstet Gynecol. 2017;129(5):e150-e154.
}
\examples{

# Example 1: Standard LMP (28 day cycle)
calculate_pregnancy_due_date("2023-01-01", "LMP")

# Example 2: Long Cycle (30 days)
calculate_pregnancy_due_date("2023-01-01", "LMP", 30)

# Example 3: IVF 5-Day Transfer
calculate_pregnancy_due_date("2023-01-15", "IVF_5_Day")
}
