\name{braden_score}
\alias{braden_score}
\title{
Braden Score for Pressure Ulcer Risk
}
\description{
Calculates the Braden Score, a widely used tool for assessing the risk of developing pressure ulcers (bedsores) in adult patients. The scale evaluates six subscales: sensory perception, moisture, activity, mobility, nutrition, and friction/shear. Lower scores indicate higher risk.
}
\usage{
braden_score(sensory_perception, moisture, activity, mobility,
             nutrition, friction_shear)
}
\arguments{
  \item{sensory_perception}{
Numeric (1-4). Ability to respond meaningfully to pressure-related discomfort.
1: Completely Limited (Unresponsive).
2: Very Limited (Responds only to painful stimuli).
3: Slightly Limited (Responds to verbal commands).
4: No Impairment.
}
  \item{moisture}{
Numeric (1-4). Degree to which skin is exposed to moisture.
1: Constantly Moist.
2: Very Moist (Often).
3: Occasionally Moist.
4: Rarely Moist.
}
  \item{activity}{
Numeric (1-4). Degree of physical activity.
1: Bedfast.
2: Chairfast.
3: Walks Occasionally.
4: Walks Frequently.
}
  \item{mobility}{
Numeric (1-4). Ability to change and control body position.
1: Completely Immobile.
2: Very Limited.
3: Slightly Limited.
4: No Limitation.
}
  \item{nutrition}{
Numeric (1-4). Usual food intake pattern.
1: Very Poor.
2: Probably Inadequate.
3: Adequate.
4: Excellent.
}
  \item{friction_shear}{
Numeric (1-3). Friction and shear problem.
1: Problem (Requires moderate/max assist).
2: Potential Problem.
3: No Apparent Problem.
}
}
\value{
A list containing:
\item{Braden_Score}{The calculated total score (Range 6-23).}
\item{Risk_Category}{Risk classification (Severe Risk <=9, High 10-12, Moderate 13-14, Mild 15-18, No Risk 19-23).}
}
\references{
Bergstrom N, Braden BJ, Laguzza A, Holman V. The Braden Scale for Predicting Pressure Sore Risk. Nurs Res. 1987;36(4):205-210.
}
\examples{

# Example 1: High Risk Patient
# Unresponsive (1), Constantly moist (1), Bedfast (1), Immobile (1), Poor nutrition (1), Sliding (1)
# Score = 6
braden_score(1, 1, 1, 1, 1, 1)

# Example 2: Mild Risk
# Slightly limited sensory (3), Occasional moisture (3), Walks occasionally (3),
# Slightly limited mobility (3), Adequate nutrition (3), No friction (3)
# Score = 18
braden_score(3, 3, 3, 3, 3, 3)
}
