\name{ascvd_2013_risk_calculator}
\alias{ascvd_2013_risk_calculator}
\title{
ASCVD Risk Estimator (2013 ACC/AHA Guidelines)
}
\description{
Calculates the 10-year estimated risk of atherosclerotic cardiovascular disease (ASCVD) events (fatal/non-fatal MI or Stroke) using the 2013 ACC/AHA Pooled Cohort Equations. The calculator is valid for adults aged 40-79 without existing cardiovascular disease.
}
\usage{
ascvd_2013_risk_calculator(age, sex, race, total_cholesterol, hdl_cholesterol,
                           systolic_bp, bp_medication, diabetes, smoker)
}
\arguments{
  \item{age}{
Numeric. Patient age in years (Valid range: 40-79).
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{race}{
String. Patient race ("White", "African American", or "Other"). Note: "Other" uses the White coefficients as per guideline recommendation.
}
  \item{total_cholesterol}{
Numeric. Total Cholesterol in mg/dL.
}
  \item{hdl_cholesterol}{
Numeric. HDL Cholesterol in mg/dL.
}
  \item{systolic_bp}{
Numeric. Systolic Blood Pressure in mmHg.
}
  \item{bp_medication}{
Numeric (0 or 1). Is the patient taking medication for high blood pressure? (1 = Yes, 0 = No).
}
  \item{diabetes}{
Numeric (0 or 1). Does the patient have diabetes? (1 = Yes, 0 = No).
}
  \item{smoker}{
Numeric (0 or 1). Is the patient a current smoker? (1 = Yes, 0 = No).
}
}
\value{
A list containing:
\item{Ten_Year_ASCVD_Risk_Percent}{The estimated 10-year risk percentage.}
\item{Risk_Category}{Classification (Low, Borderline, Intermediate, High).}
\item{Recommendation}{Guidance on statin therapy initiation based on the 2018 Guideline on the Management of Blood Cholesterol update to these risk categories.}
}
\references{
Goff DC Jr, Lloyd-Jones DM, Bennett G, et al. 2013 ACC/AHA guideline on the assessment of cardiovascular risk: a report of the American College of Cardiology/American Heart Association Task Force on Practice Guidelines. Circulation. 2014;129(25 Suppl 2):S49-73. doi:10.1161/01.cir.0000437741.48606.98
}
\examples{

# Example 1: High Risk
# 65yo Male, AfrAm, TotChol 200, HDL 40, SBP 150 (Treated), Smoker, Diabetes
ascvd_2013_risk_calculator(65, "male", "aa", 200, 40, 150, 1, 1, 1)

# Example 2: Low Risk
# 45yo Female, White, TotChol 170, HDL 60, SBP 110 (Untreated), Non-Smoker, No DM
ascvd_2013_risk_calculator(45, "female", "white", 170, 60, 110, 0, 0, 0)
}
