\name{action_icu_nstemi}
\alias{action_icu_nstemi}
\title{
ACTION ICU Score for NSTEMI
}
\description{
Calculates the ACTION ICU Score to predict the risk of in-hospital complications (cardiac arrest, shock, high-grade AV block, respiratory failure, stroke, or death) in patients with Non-ST-Elevation Myocardial Infarction (NSTEMI). This tool helps triage patients who may benefit from Intensive Care Unit (ICU) admission versus those who can be safely managed in a non-ICU setting (e.g., step-down or telemetry unit).
}
\usage{
action_icu_nstemi(age, creatinine, heart_rate, sbp, troponin_x_uln,
                  heart_failure, st_depression, prior_revasc, chronic_lung_disease)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 70 years adds +1 point).
}
  \item{creatinine}{
Numeric. Serum creatinine in mg/dL. (>= 1.1 mg/dL adds +1 point).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute (bpm).
(< 85: 0 points; 85-100: +1 point; >= 100: +3 points).
}
  \item{sbp}{
Numeric. Systolic blood pressure in mmHg.
(< 125: +3 points; 125-145: +1 point; > 145: 0 points).
}
  \item{troponin_x_uln}{
Numeric. Initial troponin level expressed as a multiple of the Upper Limit of Normal (e.g., if Troponin is 0.5 and ULN is 0.1, input 5). (>= 12x ULN adds +2 points).
}
  \item{heart_failure}{
Numeric (0 or 1). Signs or symptoms of heart failure on admission. (Yes adds +5 points).
}
  \item{st_depression}{
Numeric (0 or 1). ST-segment depression on ECG. (Yes adds +1 point).
}
  \item{prior_revasc}{
Numeric (0 or 1). History of prior coronary revascularization (PCI or CABG).
Note: **Absence** of prior revascularization adds risk in this model.
(No = +1 point; Yes = 0 points).
}
  \item{chronic_lung_disease}{
Numeric (0 or 1). History of chronic lung disease (e.g., COPD). (Yes adds +2 points).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated ACTION ICU Score (Range 0-17).}
\item{Risk_Prediction}{Estimated risk of complications requiring ICU care.}
\item{Recommendation}{Guidance on ICU vs. non-ICU admission based on the score threshold of 5.}
}
\references{
Fanari Z, et al. Risk Score to Predict Need for Intensive Care in Initially Hemodynamically Stable Adults With Non-ST-Segment-Elevation Myocardial Infarction. J Am Heart Assoc. 2018;7(11):e008894. doi:10.1161/JAHA.118.008894
}
\examples{

# Example 1: High Risk Candidate for ICU
# 72yo (+1), Cr 1.5 (+1), HR 110 (+3), SBP 110 (+3), HF present (+5), No prior revasc (+1)
# Score = 14 -> High Risk
action_icu_nstemi(72, 1.5, 110, 110, 5, 1, 0, 0, 0)

# Example 2: Low Risk (Floor Candidate)
# 60yo (0), Cr 0.9 (0), HR 70 (0), SBP 150 (0), Trop 2x (0), No HF (0), Prior Revasc (0)
# Score = 0
action_icu_nstemi(60, 0.9, 70, 150, 2, 0, 0, 1, 0)
}
