\name{abc2_ich_volume}
\alias{abc2_ich_volume}
\title{
ABC/2 Formula for Intracerebral Hemorrhage Volume
}
\description{
Calculates the estimated volume of an intracerebral hemorrhage (ICH) using the ABC/2 formula. This simple geometric approximation correlates well with planimetric measurements and is widely used for prognosis and treatment stratification.

The formula assumes an ellipsoid shape: Volume = (A * B * C) / 2.
}
\usage{
abc2_ich_volume(hemorrhage_length_cm, hemorrhage_width_cm, num_slices, slice_thickness_mm)
}
\arguments{
  \item{hemorrhage_length_cm}{
Numeric. The greatest diameter of the hemorrhage on the CT slice with the largest area (A).
}
  \item{hemorrhage_width_cm}{
Numeric. The diameter perpendicular to A on the same CT slice (B).
}
  \item{num_slices}{
Numeric. The number of CT slices containing the hemorrhage.
Guidelines for counting slices:
- Slice with >= 75\% of the largest area: Counts as 1 slice.
- Slice with 25-75\% of the largest area: Counts as 0.5 slices.
- Slice with < 25\% of the largest area: Counts as 0 slices.
}
  \item{slice_thickness_mm}{
Numeric. The thickness of each CT slice in millimeters (typically provided in the scan metadata).
}
}
\value{
A list containing:
\item{ICH_Volume_mL}{The calculated hemorrhage volume in cubic centimeters (mL).}
\item{Interpretation}{Prognostic note based on the 30 mL cutoff used in the ICH Score.}
}
\references{
Kothari RU, Brott T, Broderick JP, et al. The ABCs of measuring intracerebral hemorrhage volumes. Stroke. 1996;27(8):1304-1305. doi:10.1161/01.str.27.8.1304
}
\examples{

# Example 1: Large Hemorrhage
# 5cm x 4cm on largest slice, 12 slices total (all full size), 5mm thickness
# C = 12 * 0.5cm = 6cm. Volume = (5 * 4 * 6) / 2 = 60 mL
abc2_ich_volume(5, 4, 12, 5)

# Example 2: Small Hemorrhage
# 3cm x 2cm, 3 slices (5mm thick)
# C = 3 * 0.5cm = 1.5cm. Volume = (3 * 2 * 1.5) / 2 = 4.5 mL
abc2_ich_volume(3, 2, 3, 5)
}
