% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bjobs.R
\name{bjobs}
\alias{bjobs}
\alias{bjobs_raw}
\alias{brecent}
\alias{bjobs_running}
\alias{bjobs_pending}
\alias{bjobs_done}
\alias{bjobs_exit}
\title{Summary of jobs}
\usage{
bjobs(
  status = c("RUN", "PEND"),
  max = Inf,
  filter = NULL,
  print = TRUE,
  job_id = NULL
)

bjobs_raw(fields = "jobid stat job_name queue")

brecent(max = 20, filter = NULL)

bjobs_running(max = Inf, filter = NULL)

bjobs_pending(max = Inf, filter = NULL)

bjobs_done(max = Inf, filter = NULL)

bjobs_exit(max = Inf, filter = NULL)
}
\arguments{
\item{status}{Status of the jobs. Use "all" for all status}

\item{max}{Maximal number of recent jobs.}

\item{filter}{Regular expression on job names.}

\item{print}{Whether to print the table.}

\item{job_id}{A single job ID, internally used.}

\item{fields}{Supported output fields, check \url{https://www.ibm.com/docs/en/spectrum-lsf/10.1.0?topic=information-customize-job-output}.
The value can be a vector of field names or a single string that already includes output fields separated by space.}
}
\value{
A data frame with selected job summaries.
}
\description{
Summary of jobs
}
\details{
There is an additional column "RECENT" which is the order
for the job with the same name. 1 means the most recent job.

You can directly type \code{bjobs} without parentheses which runs \code{bjobs} with defaults.
\itemize{
\item \code{brecent} shows the most recent.
\item \code{bjobs_done} shows the "DONE" jobs.
\item \code{bjobs_exit} shows the "EXIT" jobs.
\item \code{bjobs_pending} shows the "PEND" jobs.
\item \code{bjobs_running} shows the "RUN" jobs.
}

\code{bjobs_raw()} returns the table from the original \verb{bsubs -a -o '...'} call.
}
\examples{
\dontrun{
bjobs # this is the same as bjobs()
bjobs() # all running and pending jobs
bjobs(status = "all") # all jobs
bjobs(status = "RUN") # all running jobs, you can also use `bjobs_running`
bjobs(status = "PEND") # all pending jobs, you can also use `bjobs_pending`
bjobs(status = "DONE") # all done jobs, you can also use `bjobs_done`
bjobs(status = "EXIT") # all exit jobs, you can also use `bjobs_exit`
bjobs(status = "all", max = 20) # last 20 jobs
bjobs(status = "DONE", filter = "example") # done jobs with name '.*example.*'
}
\dontrun{
brecent  # this is the same as `brecent()`
brecent() # last 20 jobs (from all status)
brecent(max = 50) # last 50 jobs
brecent(filter = "example") # last 20 jobs with name ".*example.*"
}
\dontrun{
bjobs_running  # this is the same as `bjobs_running()`
bjobs_running() # all running jobs
bjobs_running(max = 50) # last 50 running jobs
bjobs_running(filter = "example") # running jobs with name ".*example.*"
}
\dontrun{
bjobs_pending  # this is the same as `bjobs_pending()`
bjobs_pending() # all pending jobs
bjobs_pending(max = 50) # last 50 pending jobs
bjobs_pending(filter = "example") # pending jobs with name ".*example.*"
}
\dontrun{
bjobs_done  # this is the same as `bjobs_done()`
bjobs_done() # all done jobs
bjobs_done(max = 50) # last 50 done jobs
bjobs_done(filter = "example") # done jobs with name ".*example.*"
}
\dontrun{
bjobs_exit  # this is the same as `bjobs_exit()`
bjobs_exit() # all exit jobs
bjobs_exit(max = 50) # last 50 exit jobs
bjobs_exit(filter = "example") # exit jobs with name ".*example.*"
}
}
