% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tree.R
\name{load_tree_json}
\alias{load_tree_json}
\title{Load a decision tree from a JSON file (Hierarchical Format)}
\usage{
load_tree_json(file_path)
}
\arguments{
\item{file_path}{The path to the .jsn or .json file.}
}
\value{
A \code{data.tree} object, fully constructed and initialised with \code{answer}
and \code{confidence} attributes set to \code{NA}.
}
\description{
Reads a JSON  file from a given path and constructs a tree. This
function expects the JSON to define the tree in a hierarchical (nested)
format. It uses \code{load_tree_node_list} to construct the tree object.
}
\examples{

#' # Load data from the `ethical.json` file included with this package
path <- system.file("extdata", "ethical.json", package = "andorR")
ethical_tree <- load_tree_json(path)

# View the tree
print_tree(ethical_tree)

}
\seealso{
\code{\link[=load_tree_node_list]{load_tree_node_list()}} for the underlying constructor function.
}
