% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluation.GGMM.R
\name{Evaluation.GGMM}
\alias{Evaluation.GGMM}
\title{Evaluation function for the estimated Gaussian graphical mixture models.}
\usage{
Evaluation.GGMM(data, mu_hat, Theta_hat, Mu0, Theta0, M0, L.mat, L0, prob)
}
\arguments{
\item{data}{The target data, a n * p matrix, where n is the sample size and p is data dimension.}

\item{mu_hat}{M0_hat * p matrix, the estimated mean vectors of M0_hat subgroups.}

\item{Theta_hat}{p * p * M0_hat array, the estimated precision matrices of M0_hat subgroups.}

\item{Mu0}{M0 * p matrix, the true mean vectors of M0 subgroups.}

\item{Theta0}{p * p * M0 array, the true precision matrices of M0 subgroups.}

\item{M0}{The true number of subgroups}

\item{L.mat}{The estimated clustering results.}

\item{L0}{The true clustering results.}

\item{prob}{The estimated subgroup proportion.}
}
\value{
The vector including:
K: The estimated number of subgroups.
CE: The sub-grouping error
CME: The mean squared error (MSE) for the mean vectors.
PME: The mean squared error (MSE) for the precision matrices.
TPR/FPR: The true and false positive rates for the off-diagonal elements of the precision matrices.
}
\description{
Evaluation function for the estimated Gaussian graphical mixture models.
}
\references{
Ren, M., Zhang S., Zhang Q. and Ma S. (2020). Gaussian Graphical Model-based Heterogeneity Analysis via Penalized Fusion. Biometrics.
}
\author{
Mingyang Ren \href{mailto:renmingyang17@mails.ucas.ac.cn}{renmingyang17@mails.ucas.ac.cn}.
}
