% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.0.R
\name{tsqqplot}
\alias{tsqqplot}
\title{Quantile-Quantile Plots}
\usage{
tsqqplot(
  x,
  title = NULL,
  x.name = NULL,
  qq.pwidth = 0.7,
  qq.lwidth = 0.7,
  qq.col = "black",
  qqline.col = "red"
)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix.}

\item{title}{title of the QQ plot. Default is \code{NULL}.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{qq.pwidth}{size of the markers in the QQ plot. Default is \code{0.7}.}

\item{qq.lwidth}{line width of the theoretical normal line in the QQ plot. Default is \code{0.7}.}

\item{qq.col}{colour of the data points in the QQ plot. Default is `\code{black}`.}

\item{qqline.col}{colour of the theoretical normal line in the QQ plot. Default is `\code{red}`.}
}
\value{
A QQ plot of \code{x} will be displayed with no further values or objects returned.
}
\description{
`\code{tsqqplot}` is a function to produce a normal QQ plot of the values in \code{y}.
}
\examples{
tsqqplot(airport$Travellers)
}
\references{
Switzer, P. (1976). Confidence procedures for two-sample problems. \emph{Biometrika}, \strong{63}(1), 13-25. \doi{10.1093/biomet/63.1.13}.
}
\author{
Ka Yui Karl Wu
}
