% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_residuals.R
\name{quantile_sglg}
\alias{quantile_sglg}
\title{Quantile Residuals for a Generalized Log-gamma Regression Model}
\usage{
quantile_sglg(fit)
}
\arguments{
\item{fit}{is an object sglg. This object is returned from the call to glg(), sglg(), survglg() or ssurvglg().}
}
\description{
\code{quantile_sglg} is used to generate quantile residuals for a generalized log-gamma regression model.
}
\examples{
# Example 1
n <- 400
set.seed(4)
error <- rglg(n,0,0.5,1)
y <- as.data.frame(0.5 + error)
names(y) <- "y"
fit_0 <- glg(y~1,data=y)
fit_0$mu
fit_0$sigma
fit_0$lambda
quantile_sglg(fit_0)
# Example 2
n <- 500
set.seed(6)
error <- rglg(n,0,0.5,1)
x1 <- runif(n,-1,1)
beta <- c(0.5,2)
y <- cbind(1,x1)\%*\%beta + error
data <- data.frame(y=y,x1=x1)
fit_1 <- glg(y~x1,data=data)
fit_1$mu
fit_1$sigma
fit_1$lambda
quantile_sglg(fit_1)
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
