% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_site.R
\name{set_site}
\alias{set_site}
\title{set Site Information for Fossil Sites}
\usage{
set_site(
  x = NA,
  siteid = NA_integer_,
  sitename = NA_character_,
  geography = sf::st_as_sf(sf::st_sfc()),
  altitude = NA_integer_,
  geopolitical = list(),
  area = NA_integer_,
  notes = NA_character_,
  description = NA_character_,
  collunits = NULL
)
}
\arguments{
\item{x}{Object to be set as a site}

\item{siteid}{The unique \verb{site id} for a site.
If this site is new to Neotoma then leave the ID as NA.}

\item{sitename}{Name of a site.}

\item{geography}{A \code{sf} object representing the site location,
either as a polygon or point.}

\item{altitude}{altitude/elevation of the site.}

\item{geopolitical}{The geopolitical unit in which the site is located.}

\item{area}{The area of the site or depositional basin in \emph{ha}.
Can be calculated from the polygon.}

\item{notes}{additional information of the site}

\item{description}{Function to create new site objects.
The new object will not be uploaded to the database.}

\item{collunits}{Collection units in the site}
}
\value{
\code{site} object
}
\description{
set Site Information for Fossil Sites
}
\examples{
{
# Create a site called "My Lake", to
x <- sf::st_as_sf(sf::st_sfc(sf::st_point(c(5,5))))
my_site <- set_site(sitename = "My Lake",
                    geography = x,
                    description = "my lake",
                    altitude = 30)
}
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}
}
