% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_sd.R
\name{mean_sd}
\alias{mean_sd}
\alias{mean_sd.data.frame}
\alias{mean_sd.survey.design}
\alias{mean_sd.default}
\title{Compute means, standard deviations and confidence intervals by sub-groups}
\usage{
mean_sd(data, ...)

\method{mean_sd}{data.frame}(
  data,
  ...,
  .by = NULL,
  .drop = FALSE,
  .drop_na_by = FALSE,
  .conf.int = FALSE,
  .conf.level = 0.95,
  .options = NULL
)

\method{mean_sd}{survey.design}(
  data,
  ...,
  .by = NULL,
  .drop = FALSE,
  .drop_na_by = FALSE,
  .conf.int = FALSE,
  .conf.level = 0.95,
  .options = NULL
)

\method{mean_sd}{default}(
  data,
  ...,
  .drop = FALSE,
  .conf.int = FALSE,
  .conf.level = 0.95,
  .options = NULL
)
}
\arguments{
\item{data}{A vector, a data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variable(s) for which
to compute mean and standard deviation.}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optional additional
variables to group by (in addition to those eventually previously declared
using \code{\link[dplyr:group_by]{dplyr::group_by()}}).}

\item{.drop}{If \code{TRUE}, will remove empty groups from the output.}

\item{.drop_na_by}{If \code{TRUE}, will remove any \code{NA} values observed in the
\code{.by} variables (or variables defined with \code{\link[dplyr:group_by]{dplyr::group_by()}}).}

\item{.conf.int}{If \code{TRUE}, will estimate confidence intervals.}

\item{.conf.level}{Confidence level for the returned confidence intervals.}

\item{.options}{Additional arguments passed to \code{\link[stats:t.test]{stats::t.test()}}
or \code{\link[srvyr:survey_mean]{srvyr::survey_mean()}}.}
}
\value{
A tibble. Column \code{"n"} reports the number of valid observations
and \code{"missing"} the number of missing (\code{NA}) observations, unweighted for
survey objects.

A tibble with one row per group.
}
\description{
\code{mean_sd()} lets you quickly compute mean and standard deviation by
sub-groups. Use \code{.conf.int = TRUE} to also return confidence intervals of the
mean.
}
\examples{
# using a vector
iris$Petal.Length |> mean_sd()

# one variable
iris |> mean_sd(Petal.Length)
iris |> mean_sd(Petal.Length, .conf.int = TRUE)
iris |> mean_sd(Petal.Length, .by = Species)
mtcars |> mean_sd(mpg, .by = c(cyl, gear))

# two variables
iris |> mean_sd(Petal.Length, Petal.Width)
iris |> mean_sd(dplyr::pick(dplyr::starts_with("Petal")), .by = Species)

# missing values
d <- iris
d$Petal.Length[1:10] <- NA
d |> mean_sd(Petal.Length)
d |> mean_sd(Petal.Length, .by = Species)

\donttest{
## SURVEY DATA ------------------------------------------------------

ds <- srvyr::as_survey(iris)
ds |> mean_sd(Petal.Length, .by = Species, .conf.int = TRUE)
}
}
\keyword{univar}
