% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.r
\name{voronoi,GVector-method}
\alias{voronoi,GVector-method}
\alias{voronoi}
\title{Voronoi tessellation}
\usage{
\S4method{voronoi}{GVector}(x, buffer = 0)
}
\arguments{
\item{x}{A \code{GVector} "points" object.}

\item{buffer}{Numeric: By default, this function creates a vector that has an extent exactly the same as the input data. However, the apparent extent can be changed by setting this value to a value different from 0. Negative values reduce the size of the extent, and positive extend it.  Units are in map units.}
}
\value{
A \code{GVector}.
}
\description{
This function creates a Voronoi tessellation from a set of spatial points or polygons.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Example vectors
madDypsis <- fastData("madDypsis") # points
madCoast4 <- fastData("madCoast4") # polygons

# Convert sf vectors to GVectors
dypsis <- fast(madDypsis)
coast4 <- fast(madCoast4)
ant <- coast4[coast4$NAME_4 == "Antanambe"]

# Delaunay triangulation
dypsisDel <- delaunay(dypsis)
plot(dypsisDel)
plot(dypsis, pch = 1, col = "red", add = TRUE)

# Voronoi tessellation
vor <- voronoi(dypsis)
plot(vor)
plot(dypsis, pch = 1, col = "red", add = TRUE)

# Random Voronoi tessellation
rand <- rvoronoi(coast4, size = 100)
plot(rand)

}
}
\seealso{
\code{\link[terra:voronoi]{terra::voronoi()}}, \code{\link[sf:geos_unary]{sf::st_voronoi()}}, tool \code{v.voronoi} in \strong{GRASS}
}
