% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect.r
\name{intersect,GVector,GVector-method}
\alias{intersect,GVector,GVector-method}
\alias{intersect}
\title{Intersection of two GVectors}
\usage{
\S4method{intersect}{GVector,GVector}(x, y)
}
\arguments{
\item{x, y}{\code{GVector}s.}
}
\value{
A \code{GVector}.
}
\description{
The \code{intersect()} function selects the area of overlap between two \code{GVector}s of the same type (points, lines or polygons). You can also use the \code{*} operator (e.g., \code{vect1 * vect2}).
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Polygon of coastal Madagascar and Dypsis specimens
madCoast4 <- fastData("madCoast4") # polygons
madDypsis <- fastData("madDypsis") # points

# Convert vectors:
coast4 <- fast(madCoast4)
dypsis <- fast(madDypsis)

# Create another polygons vector from a convex hull around Dypsis points
hull <- convHull(dypsis)

### union()

unioned <- union(coast4, hull)
plot(unioned)

plus <- coast4 + hull # same as union()

### intersect

inter <- intersect(coast4, hull)
plot(coast4)
plot(hull, border = "red", add = TRUE)
plot(inter, border = "blue", add = TRUE)

### xor

xr <- xor(coast4, hull)
plot(coast4)
plot(xr, border = "blue", add = TRUE)

### erase

erased <- erase(coast4, hull)
plot(coast4)
plot(erased, border = "blue", add = TRUE)

minus <- coast4 - hull # same as erase()

}
}
\seealso{
\code{\link[=c]{c()}}, \code{\link[=aggregate]{aggregate()}}, \code{\link[=crop]{crop()}}, \code{\link[=union]{union()}}, \code{\link[=xor]{xor()}}
}
