% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Matrix.R
\name{upperPadding}
\alias{upperPadding}
\title{Padding (a list of) sparse matrices.}
\usage{
upperPadding(M, relative = FALSE, ...)
}
\arguments{
\item{M}{'Matrix' (or a list of them).}

\item{relative}{logical. If 'M" is a list,
it indicates if it is to be returned a relative index
and the value for each matrix. See details.}

\item{...}{additional arguments passed to \link{Sparse}.}
}
\value{
If a unique matrix is given, return the
upper triangle considering the 'T' representation
in the \code{dgTMatrix}, from the \code{Matrix} package.
If a list of matrices is given,
return a list of two elements: 'graph' and 'xx'.
The 'graph' is the union of the graph from each matrix.
If relative=FALSE, 'xx' is a matrix with number of column equals
the the number of matrices imputed.
If relative=TRUE, it is a list of length equal the number
of matrices imputed. See details.
}
\description{
Padding (a list of) sparse matrices.
}
\details{
This is useful to prepare a matrix, or a list of,
sparse matrices for use in some 'cgeneric' code.

Define a graph of the union of the supplied matrices
and return the row ordered diagonal plus upper triangle
after padding with zeroes each one so that
all the returned matrices have the same pattern.

If relative=FALSE, each columns of 'xx' is the
elements of the corresponding matrix after being padded
to fill the pattern of the union graph.
If relative=TRUE, each element of 'xx' would be a list
with a relative index, 'r', for each non-zero elements of
each matrix is returned relative to the union graph,
the non-lower elements, 'x', of the corresponding matrix,
and a vector, 'o', with the number of non-zero elements
for each line of each resulting matrix.
}
\examples{
A <- sparseMatrix(
  i = c(1, 1, 2, 3, 3, 5),
  j = c(2, 5, 3, 4, 5, 5),
  x = -c(0:3,NA,1), symmetric = TRUE)
A
upperPadding(A)
upperPadding(A, na.rm = TRUE)
upperPadding(A, zeros.rm = TRUE)
upperPadding(A, na.rm = TRUE, zeros.rm = TRUE)
B <- Diagonal(nrow(A), -colSums(A, na.rm = TRUE))
B
upperPadding(list(a = A, b = B), na.rm = TRUE, zeros.rm = TRUE)
upperPadding(list(a = A, b = B), relative = TRUE)
}
