% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_kronecker.R
\name{multi_generic_model}
\alias{multi_generic_model}
\title{Combine two or more \code{cgeneric} or \code{rgeneric} models}
\usage{
multi_generic_model(models, ...)
}
\arguments{
\item{models}{A list of \code{cgeneric} or \code{rgeneric} models, optionally with names}

\item{\dots}{Arguments passed on to every \code{kronecker()} call.}
}
\value{
A 'cgeneric' or 'rgeneric' model object, containing a
multi-kronecker product model, with a corresponding \code{\link[inlabru:bm_multi]{inlabru::bm_multi()}}
mapper.
}
\description{
Constructs a multiple kronecker product model from a list of model
objects. The resulting model contains a corresponding \code{\link[inlabru:bm_multi]{inlabru::bm_multi()}}
mapper. This can be used as an alternative to a binary tree of kronecker
product models.
}
\details{
The last model in the list has the slowest index variation, and the
first model has the fastest index variation. This matches the latent
variable ordering of standard \code{INLA:f()} model components with
\verb{(main, group, replicate)}.
}
\examples{
R1 <- Matrix(crossprod(diff(diag(4))))
m1 <- cgeneric("generic0", R = R1, param = c(1, NA),
  scale = FALSE, useINLAprecomp = FALSE)
R2 <- Matrix(crossprod(diff(diag(3))))
m2 <- cgeneric("generic0", R = R2, param = c(1, NA),
  scale = FALSE, useINLAprecomp = FALSE)
m3 <- cgeneric("iid", n = 2, param = c(1, 0.5),
  useINLAprecomp = FALSE)
multi123 <- multi_generic_model(
  list(m1 = m1, m2 = m2, m3 = m3),
  useINLAprecomp = FALSE
)
prec(multi123, theta = 0.0)
if(!is.na(packageCheck("inlabru", "2.13.0.9005"))) {
  print(multi123$mapper)
}
}
