% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Annotation_Features.R
\name{Celltype_Annotation_Features}
\alias{Celltype_Annotation_Features}
\title{Annotate cell types using features plot with different marker databases}
\usage{
Celltype_Annotation_Features(
  seurat_obj,
  gene_list,
  gene_list_type = "Default",
  species = NULL,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  save_path = NULL,
  min_counts = 1,
  metric_names = NULL,
  colour_low = "white",
  colour_high = "navy",
  colour_low_mertic = "white",
  colour_high_mertic = "navy",
  ...
)
}
\arguments{
\item{seurat_obj}{A valid Seurat object with cluster annotations in \code{meta.data}.}

\item{gene_list}{A list of data frames containing marker genes and metrics.
Format depends on \code{gene_list_type}:
- \strong{Cellmarker2}: Generated by \code{Markers_filter_Cellmarker2()}.
- \strong{PanglaoDB}: Generated by \code{Markers_filter_PanglaoDB()}.
- \strong{Seurat}: Generated by \code{read_seurat_markers()}.
- \strong{Excel}: Generated by \code{read_excel_markers()}.}

\item{gene_list_type}{Type of marker database to use. Be one of:
\code{"Cellmarker2"}, \code{"PanglaoDB"}, \code{"Seurat"}, or \code{"Excel"}.}

\item{species}{Species of the dataset: \code{"Human"} or \code{"Mouse"} for gene name standardization.}

\item{cluster_col}{Column name in \code{meta.data} defining clusters (default: \code{"seurat_clusters"}).}

\item{assay}{Assay layer in the Seurat object (default: \code{"RNA"}).}

\item{save_path}{Directory to save output PNGs. Must be explicitly specified.}

\item{min_counts}{Minimum number of counts for Cellmarker2 annotations (default: \code{1}).}

\item{metric_names}{Optional. Change the row name for the input mertics, not recommended unless
necessary. (NULL is used as default parameter; used in "Seurat"/"Excel").}

\item{colour_low}{Color for lowest expression level. (default = "white")}

\item{colour_high}{Color for highest expression level. (default = "navy")}

\item{colour_low_mertic}{Color for lowest mertic level. (default = "white")}

\item{colour_high_mertic}{Color for highest mertic level. (default = "navy")}

\item{...}{Additional parameters passed to the specific annotation function.}
}
\value{
Saves cell type annotation PNGs in \code{save_path}. Returns invisibly.
}
\description{
This function dynamically selects the appropriate annotation method
based on the \code{gene_list_type} parameter. It supports marker databases from
Cellmarker2, PanglaoDB, Seurat (via \code{FindAllMarkers}), or Excel files.
}
\examples{
\dontrun{
# Example for Cellmarker2
Celltype_Annotation_Features(seurat_obj = sce,
    gene_list = Markers_list_Cellmarker2,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    save_path = file.path(tempdir(),"SlimR_Celltype_annotation_Cellmarker2"),
    colour_low = "white",
    colour_high = "navy",
    colour_low_mertic = "white",
    colour_high_mertic = "navy",
    )

# Example for PanglaoDB
Celltype_Annotation_Features(seurat_obj = sce,
    gene_list = Markers_list_panglaoDB,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    save_path = file.path(tempdir(),"SlimR_Celltype_annotation_PanglaoDB")
    colour_low = "white",
    colour_high = "navy",
    colour_low_mertic = "white",
    colour_high_mertic = "navy",
    )

# Example for Seurat marker list
Celltype_Annotation_Features(seurat_obj = sce,
    gene_list = Markers_list_Seurat,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    save_path = file.path(tempdir(),"SlimR_Celltype_annotation_Seurat")
    colour_low = "white",
    colour_high = "navy",
    colour_low_mertic = "white",
    colour_high_mertic = "navy",
    )

# Example for Excel marker list
Celltype_Annotation_Features(seurat_obj = sce,
    gene_list = Markers_list_Excel,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    save_path = file.path(tempdir(),"SlimR_Celltype_annotation_Excel")
    colour_low = "white",
    colour_high = "navy",
    colour_low_mertic = "white",
    colour_high_mertic = "navy",
    )
}

}
\seealso{
Other Section_4_Semi_Automated_Annotation_Workflow: 
\code{\link{Celltype_Annotation_Combined}()},
\code{\link{Celltype_Annotation_Heatmap}()}
}
\concept{Section_4_Semi_Automated_Annotation_Workflow}
