% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixscape.R
\name{DEenrichRPlot}
\alias{DEenrichRPlot}
\title{DE and EnrichR pathway visualization barplot}
\usage{
DEenrichRPlot(
  object,
  ident.1 = NULL,
  ident.2 = NULL,
  balanced = TRUE,
  logfc.threshold = 0.25,
  assay = NULL,
  max.genes,
  test.use = "wilcox",
  p.val.cutoff = 0.05,
  cols = NULL,
  enrich.database = NULL,
  num.pathway = 10,
  return.gene.list = FALSE,
  ...
)
}
\arguments{
\item{object}{Name of object class Seurat.}

\item{ident.1}{Cell class identity 1.}

\item{ident.2}{Cell class identity 2.}

\item{balanced}{Option to display pathway enrichments for both negative and
positive DE genes.If false, only positive DE gene will be displayed.}

\item{logfc.threshold}{Limit testing to genes which show, on average, at least
X-fold difference (log-scale) between the two groups of cells. Default is 0.25.
Increasing logfc.threshold speeds up the function, but can miss weaker signals.}

\item{assay}{Assay to use in differential expression testing}

\item{max.genes}{Maximum number of genes to use as input to enrichR.}

\item{test.use}{Denotes which test to use. Available options are:
\itemize{
 \item{"wilcox"} : Identifies differentially expressed genes between two
 groups of cells using a Wilcoxon Rank Sum test (default); will use a fast
 implementation by Presto if installed
 \item{"wilcox_limma"} : Identifies differentially expressed genes between two
 groups of cells using the limma implementation of the Wilcoxon Rank Sum test;
 set this option to reproduce results from Seurat v4
 \item{"bimod"} : Likelihood-ratio test for single cell gene expression,
 (McDavid et al., Bioinformatics, 2013)
 \item{"roc"} : Identifies 'markers' of gene expression using ROC analysis.
 For each gene, evaluates (using AUC) a classifier built on that gene alone,
 to classify between two groups of cells. An AUC value of 1 means that
 expression values for this gene alone can perfectly classify the two
 groupings (i.e. Each of the cells in cells.1 exhibit a higher level than
 each of the cells in cells.2). An AUC value of 0 also means there is perfect
 classification, but in the other direction. A value of 0.5 implies that
 the gene has no predictive power to classify the two groups. Returns a
 'predictive power' (abs(AUC-0.5) * 2) ranked matrix of putative differentially
 expressed genes.
 \item{"t"} : Identify differentially expressed genes between two groups of
 cells using the Student's t-test.
 \item{"negbinom"} : Identifies differentially expressed genes between two
  groups of cells using a negative binomial generalized linear model.
  Use only for UMI-based datasets
 \item{"poisson"} : Identifies differentially expressed genes between two
  groups of cells using a poisson generalized linear model.
  Use only for UMI-based datasets
 \item{"LR"} : Uses a logistic regression framework to determine differentially
 expressed genes. Constructs a logistic regression model predicting group
 membership based on each feature individually and compares this to a null
 model with a likelihood ratio test.
 \item{"MAST"} : Identifies differentially expressed genes between two groups
 of cells using a hurdle model tailored to scRNA-seq data. Utilizes the MAST
 package to run the DE testing.
 \item{"DESeq2"} : Identifies differentially expressed genes between two groups
 of cells based on a model using DESeq2 which uses a negative binomial
 distribution (Love et al, Genome Biology, 2014).This test does not support
 pre-filtering of genes based on average difference (or percent detection rate)
 between cell groups. However, genes may be pre-filtered based on their
 minimum detection rate (min.pct) across both cell groups. To use this method,
 please install DESeq2, using the instructions at
 https://bioconductor.org/packages/release/bioc/html/DESeq2.html
}}

\item{p.val.cutoff}{Cutoff to select DE genes.}

\item{cols}{A list of colors to use for barplots.}

\item{enrich.database}{Database to use from enrichR.}

\item{num.pathway}{Number of pathways to display in barplot.}

\item{return.gene.list}{Return list of DE genes}

\item{...}{Arguments passed to other methods and to specific DE methods}
}
\value{
Returns one (only enriched) or two (both enriched and depleted)
barplots with the top enriched/depleted GO terms from EnrichR.
}
\description{
DE and EnrichR pathway visualization barplot
}
\concept{mixscape}
