% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contr.FFbHelmert.R, R/contr.FFbPoly.R
\name{contr.FFbHelmert}
\alias{contr.FFbHelmert}
\alias{contr.FFbPoly}
\title{Full-factorial-based real-valued contrasts for s^el levels}
\usage{
contr.FFbHelmert(n, s, contrasts = TRUE, slowfirst = TRUE)

contr.FFbPoly(n, s, contrasts = TRUE, slowfirst = TRUE)
}
\arguments{
\item{n}{integer or vector; either an integer number of levels of the factor for
which contrasts are created, which must be a a power of \code{s}; or a factor
whose number of levels is a power of \code{s}; or a vector of levels whose
number of elements is a power of \code{s}.}

\item{s}{positive integer, at least 2}

\item{contrasts}{logical; must be TRUE}

\item{slowfirst}{logical; default TRUE}
}
\value{
\code{contr.FFbHelmert} and \code{contr.FFbPoly} yield a matrix
of real-valued contrasts.
That matrix can be used in function \code{model.matrix}
or in any statistical modeling functions.
}
\description{
Full-factorial-based real-valued contrasts for s^el levels

Full-factorial-based polynomial contrasts for s^el levels
}
\details{
The functions implement real-valued full-factorial-based contrasts
in the sense of Groemping (2023b) that can be used
instead of the complex-valued contrasts from
Tian and Xu (2022), as implemented in function
\code{\link{contr.TianXu}}. Their main use is the calculation of the
stratification pattern (also called space-filling pattern).
Function \code{\link{Spattern}} uses function \code{contr.FFbHelmert}
for this purpose, the internal function \code{Spattern_Poly} uses
\code{contr.FFbPoly}.
}
\examples{
## the same n can yield different contrasts for different s
## Helmert variant
contr.FFbHelmert(16, 2)
round(contr.FFbHelmert(16, 4), 4)
round(contr.FFbHelmert(16, 16), 4)
## Poly variant
contr.FFbHelmert(16, 2)
round(contr.FFbHelmert(16, 4), 4)
round(contr.FFbHelmert(16, 16), 4)

}
\references{
Groemping (2023b)
Tian and Xu (2022)
}
