#' @title 27 experimental studies from
#' \insertCite{anderson2010violent;textual}{RoBMA} that meet the best practice criteria
#'
#' @description The data set contains correlation coefficients, sample
#' sizes, and labels for 27 experimental studies focusing on the effect of
#' violent video games on aggressive behavior. The full original data can
#' found at https://github.com/Joe-Hilgard/Anderson-meta.
#'
#'
#' @format A data.frame with 3 columns and 23 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Anderson2010"


#' @title 9 experimental studies from
#' \insertCite{bem2011feeling;textual}{RoBMA} as described in
#' \insertCite{bem2011must;textual}{RoBMA}
#'
#' @description The data set contains Cohen's d effect sizes, standard errors,
#' and labels for 9 experimental studies of precognition from the infamous
#' \insertCite{bem2011feeling;textual}{RoBMA} as analyzed in his later meta-analysis
#' \insertCite{bem2011must}{RoBMA}.
#'
#' @format A data.frame with 3 columns and 9 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Bem2011"


#' @title 5 studies with a tactile outcome assessment from
#' \insertCite{poulsen2006potassium;textual}{RoBMA} of the effect of potassium-containing toothpaste
#' on dentine hypersensitivity
#'
#' @description The data set contains Cohen's d effect sizes, standard errors,
#' and labels for 5 studies assessing the tactile outcome from a meta-analysis of
#' the effect of potassium-containing toothpaste on dentine hypersensitivity
#' \insertCite{poulsen2006potassium}{RoBMA} which was used as an example in
#' \insertCite{bartos2021bayesian;textual}{RoBMA}.
#'
#' @format A data.frame with 3 columns and 5 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Poulsen2006"

#' @title 881 estimates from 69 studies of a relationship between employment and
#' educational outcomes collected by \insertCite{kroupova2021student;textual}{RoBMA}
#'
#' @description The data set contains partial correlation coefficients, standard errors,
#' study labels, samples sizes, type of the educational outcome, intensity of the
#' employment, gender of the student population, study location, study design, whether
#' the study controlled for endogenity, and whether the study controlled for motivation.
#' The original data set including additional variables and the publication can be found
#' at http://meta-analysis.cz/students.
#' (Note that some standard errors and employment intensities are missing.)
#'
#' @format A data.frame with 11 columns and 881 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Kroupova2021"

#' @title 18 studies of a relationship between acculturation mismatch and
#' intergenerational cultural conflict collected by
#' \insertCite{lui2015intergenerational;textual}{RoBMA}
#'
#' @description The data set contains correlation coefficients r,
#' sample sizes n, and labels for each study assessing the
#' relationship between acculturation mismatch (that is the result of the contrast
#' between the collectivist cultures of Asian and Latin immigrant groups
#' and the individualist culture in the United States) and intergenerational cultural
#' conflict \insertCite{lui2015intergenerational}{RoBMA} which was used as an
#' example in \insertCite{bartos2020adjusting;textual}{RoBMA}.
#'
#' @format A data.frame with 3 columns and 18 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Lui2015"

#' @title 36 estimates of the effect of household chaos on child executive functions
#' with the mean age and assessment type covariates from a meta-analysis by
#' \insertCite{andrews2021examining;textual}{RoBMA}
#'
#' @description The data set contains correlation coefficients \code{r},
#' standard errors \code{se}, executive functioning assessment type \code{measure},
#' and the mean age of the children in each study \code{age}. The original data set
#' assessed the effect of household chaos on child executive functions
#' \insertCite{andrews2021examining}{RoBMA} which was used as an
#' example in \insertCite{bartos2020adjusting;textual}{RoBMA}.
#'
#' @format A data.frame with 4 columns and 36 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Andrews2021"

#' @title 70 effect sizes from a meta-analysis of ChatGPT's impact on student learning
#' by \insertCite{wang2025effect;textual}{RoBMA}
#'
#' @description The data set contains Hedges' g effect sizes, standard errors,
#' sample sizes for experimental and control groups, and various study characteristics
#' including grade level, type of course, duration, learning model, role of ChatGPT,
#' and area of ChatGPT application. The meta-analysis examined the effect of ChatGPT
#' on students' learning performance, learning perception, and higher-order thinking
#' \insertCite{wang2025effect}{RoBMA}.
#'
#' @format A data.frame with 12 columns and 70 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Wang2025"

#' @title 55 effect sizes from Many Labs 2 replication studies of
#' \insertCite{tversky1981framing;textual}{RoBMA} framing effects
#'
#' @description The data set contains standardized mean differences (y) and standard errors (se)
#' from 55 replication studies of the framing effect originally described by
#' \insertCite{tversky1981framing;textual}{RoBMA}. These studies were part of the
#' Many Labs 2 project examining variation in replicability across samples and settings
#' \insertCite{klein2018many;textual}{RoBMA}.
#'
#' @format A data.frame with 2 columns and 55 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"ManyLabs16"

#' @title 37 studies from a meta-analysis of social comparison as a behavior change technique
#' by \insertCite{hoppen2025meta;textual}{RoBMA}
#'
#' @description The data set contains Cohen's d effect sizes, variances, and study
#' characteristics including outcome type, feedback level, social comparison type,
#' number of sessions, sample type, sample size, and country. The meta-analysis
#' examined social comparison as a behavior change technique across the behavioral
#' sciences \insertCite{hoppen2025meta}{RoBMA}.
#'
#' @format A data.frame with 9 columns and 37 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Hoppen2025"

#' @title 582 effect sizes examining the ease-of-retrieval effect
#' from a meta-analysis by \insertCite{weingarten2018does;textual}{RoBMA}
#'
#' @description The data set contains correlation coefficients between the manipulation
#' and outcome variable (r_xy), sample sizes (N), and various study characteristics
#' including publication status, country (USA vs. other), number of few and many
#' examples requested, whether memory the trial targeted episodic memory, paradigm type (standard vs. other),
#' dataset type (proximal vs. distal), and mediation variables (r_xm, r_my).
#' The meta-analysis examined whether subjective ease mediates the ease-of-retrieval effect,
#' where participants list either few or many examples and then make judgments
#' \insertCite{weingarten2018does}{RoBMA}. 
#'
#' @format A data.frame with 12 columns and 582 observations.
#'
#' @return a data.frame.
#'
#' @references
#' \insertAllCited{}
"Weingarten2018"

