% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_format.R
\name{custom_format}
\alias{custom_format}
\title{Custom formatting for \code{gtsummary} tables}
\usage{
custom_format(gt_table, align = "right", column_size = NULL)
}
\arguments{
\item{gt_table}{A \code{gt} table object (also handles gtsummary tables by converting them).}

\item{align}{A character string defining the alignment of specific columns. Passed to the
\code{gt::cols_align()} function (e.g., "left", "right", "center"). Default is "right".}

\item{column_size}{A named list or vector defining the width of columns (optional). The list should specify
the width for one or more columns. If not provided, column widths will not be modified.}
}
\value{
A \code{gt} table object with the specified formatting applied.
The table will have columns aligned according to the \code{align} parameter,
and cells in the "label" rows will have bold text. If \code{column_size} is provided,
the column widths will be adjusted accordingly.
}
\description{
This function takes a \code{gt} table and applies custom formatting. It allows you to align columns,
apply bold text to certain rows, and adjust column widths if specified.
}
\examples{
# Example usage
tbl <- RastaRocket::desc_var(iris,
  table_title = "test",
  group = TRUE,
  var_group = "Species")
formatted_tbl <- custom_format(tbl,
  align = "center",
  column_size = list(label ~ gt::pct(50)))
formatted_tbl

}
