% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oibeta.R
\name{oibeta}
\alias{oibeta}
\alias{doibeta}
\alias{poibeta}
\alias{roibeta}
\title{One-inflated beta distribution}
\usage{
doibeta(x, shape1, shape2, oneprob = 0, log = FALSE)

poibeta(q, shape1, shape2, oneprob = 0, lower.tail = TRUE, log.p = FALSE)

roibeta(n, shape1, shape2, oneprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{shape1, shape2}{non-negative shape parameters of the beta distribution}

\item{oneprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{doibeta} gives the density, \code{poibeta} gives the distribution function, and \code{roibeta} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the one-inflated beta distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- roibeta(1, 2, 2, 0.5)
d <- doibeta(x, 2, 2, 0.5)
p <- poibeta(x, 2, 2, 0.5)
}
