% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph.R
\name{dsep_set}
\alias{dsep_set}
\title{D-separation of two nodes given a set in a DAG}
\usage{
dsep_set(DAG, X, Y, Z = NULL)
}
\arguments{
\item{DAG}{Directed Acyclic Graph}

\item{X}{node}

\item{Y}{node}

\item{Z}{set}
}
\value{
\code{TRUE} if the sets are d-separated and \code{FALSE} if not
}
\description{
D-separation of two nodes given a set in a DAG
}
\examples{

DAG = create_empty_DAG(5)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')

dsep_set(DAG, 'U1', 'U5')

}
