% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fda_ndc_directory.R
\name{get_fda_ndc_directory}
\alias{get_fda_ndc_directory}
\title{Search National Drug Code (NDC) Directory by Drug Name}
\source{
FDA National Drug Code Directory via openFDA:
\url{https://open.fda.gov/apis/drug/ndc/}
}
\usage{
get_fda_ndc_directory(drug_name)
}
\arguments{
\item{drug_name}{A character string representing the name of the drug
(brand name or generic name).}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{ndc}: National Drug Code (NDC) product identifier
  \item \code{brand}: Brand or proprietary name of the drug product
  \item \code{generic}: Generic (non-proprietary) name of the drug
  \item \code{ingredients}: List of active ingredients with strengths
  \item \code{form}: Pharmaceutical dosage form (e.g., TABLET, CAPSULE)
  \item \code{route}: Route of administration (e.g., ORAL, INTRAVENOUS)
  \item \code{labeler}: Name of the company that labels/markets the product
  \item \code{type}: Type of drug product (e.g., HUMAN PRESCRIPTION DRUG)
  \item \code{status}: Current marketing status (e.g., Prescription)
}
}
\description{
Retrieves National Drug Code (NDC) information from the FDA NDC Directory
that match a specific drug name using the RESTful API endpoint
\code{/drug/ndc.json?search=<drug_name>}.

This includes details such as the NDC product code, brand name, generic name,
labeler information, product type, dosage form, route of administration,
marketing status, and active ingredients for pharmaceutical products
marketed in the United States.
}
\details{
This function sends a GET request to the FDA openFDA API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

The NDC Directory contains information on final marketed drugs submitted to FDA
in SPL (Structured Product Labeling) electronic listing files. Assignment of
an NDC number does not denote FDA approval of the product.

If the API request fails, returns no matches, or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection. The NDC Directory is updated daily by FDA.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from FDA
  get_fda_ndc_directory("aspirin")
  get_fda_ndc_directory("ibuprofen")
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
