% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMM_network.R
\name{lmm_analysis}
\alias{lmm_analysis}
\title{Perform Longitudinal Analysis with Linear Mixed Models (LMM)}
\usage{
lmm_analysis(
  clinical_data,
  variables_to_scale,
  random_effects = "(1 | participant_id)"
)
}
\arguments{
\item{clinical_data}{Dataframe containing clinical and metadata for participants, including identifier as \code{participant_id}.}

\item{variables_to_scale}{Character vector of variable names to be analyzed.}

\item{random_effects}{A character string specifying the random effects formula (default: "(1 | participant_id)").}
}
\value{
A matrix of model coefficient scores, where rows represent dependent variables and columns represent independent variables.
}
\description{
This function automates the analysis of longitudinal clinical data using linear mixed models.
It models clinical variables and returns a weighted matrix of model coefficient scores.
}
