% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MMCLRpval_fun}
\alias{MMCLRpval_fun}
\title{Monte Carlo Likelihood Ratio Test P-value Function}
\usage{
MMCLRpval_fun(
  theta_h0,
  mdl_h0,
  k1,
  LT_h1,
  N,
  burnin,
  workers,
  lambda,
  stationary_constraint,
  thtol,
  Z,
  exog,
  mdl_h0_control,
  mdl_h1_control
)
}
\arguments{
\item{theta_h0}{vector of parameter values under the null being considered.}

\item{mdl_h0}{List with restricted model properties.}

\item{k1}{integer determining the number of regimes under the alternative.}

\item{LT_h1}{double specifying maximum log likelihood under alternative.}

\item{N}{integer specifying the number of replications.}

\item{burnin}{integer specifying the number of observations to drop from beginning of simulation.}

\item{workers}{Integer determining the number of workers to use for parallel computing version of test. Note that parallel pool must already be open.}

\item{lambda}{Double determining penalty on nonlinear constraint.}

\item{stationary_constraint}{Boolean determining if only stationary solutions are considered (if \code{TRUE}) or not (if \code{FALSE}).}

\item{thtol}{double determining the convergence criterion used during estimation.}

\item{mdl_h0_control}{List with controls/options used to estimate restricted model.}

\item{mdl_h1_control}{List with controls/options used to estimate unrestricted model.}
}
\value{
MMC p-value
}
\description{
This function computes the Maximum Monte Carlo P-value.
}
\keyword{internal}
