/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdouble;

import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleDoubleProcedure;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;

public class DoubleFunctions {
    public static final DoubleFunctions functions = new DoubleFunctions();
    public static final DoubleFunction abs = new DoubleFunction(){

        public final double apply(double d) {
            return Math.abs(d);
        }
    };
    public static final DoubleFunction acos = new DoubleFunction(){

        public final double apply(double d) {
            return Math.acos(d);
        }
    };
    public static final DoubleFunction asin = new DoubleFunction(){

        public final double apply(double d) {
            return Math.asin(d);
        }
    };
    public static final DoubleFunction atan = new DoubleFunction(){

        public final double apply(double d) {
            return Math.atan(d);
        }
    };
    public static final DoubleFunction ceil = new DoubleFunction(){

        public final double apply(double d) {
            return Math.ceil(d);
        }
    };
    public static final DoubleFunction cos = new DoubleFunction(){

        public final double apply(double d) {
            return Math.cos(d);
        }
    };
    public static final DoubleFunction exp = new DoubleFunction(){

        public final double apply(double d) {
            return Math.exp(d);
        }
    };
    public static final DoubleFunction floor = new DoubleFunction(){

        public final double apply(double d) {
            return Math.floor(d);
        }
    };
    public static final DoubleFunction identity = new DoubleFunction(){

        public final double apply(double d) {
            return d;
        }
    };
    public static final DoubleFunction inv = new DoubleFunction(){

        public final double apply(double d) {
            return 1.0 / d;
        }
    };
    public static final DoubleFunction log = new DoubleFunction(){

        public final double apply(double d) {
            return Math.log(d);
        }
    };
    public static final DoubleFunction log2 = new DoubleFunction(){

        public final double apply(double d) {
            return Math.log(d) * 1.4426950408889634;
        }
    };
    public static final DoubleFunction neg = new DoubleFunction(){

        public final double apply(double d) {
            return -d;
        }
    };
    public static final DoubleFunction rint = new DoubleFunction(){

        public final double apply(double d) {
            return Math.rint(d);
        }
    };
    public static final DoubleFunction sign = new DoubleFunction(){

        public final double apply(double d) {
            return d < 0.0 ? -1.0 : (d > 0.0 ? 1.0 : 0.0);
        }
    };
    public static final DoubleFunction sin = new DoubleFunction(){

        public final double apply(double d) {
            return Math.sin(d);
        }
    };
    public static final DoubleFunction sqrt = new DoubleFunction(){

        public final double apply(double d) {
            return Math.sqrt(d);
        }
    };
    public static final DoubleFunction square = new DoubleFunction(){

        public final double apply(double d) {
            return d * d;
        }
    };
    public static final DoubleFunction tan = new DoubleFunction(){

        public final double apply(double d) {
            return Math.tan(d);
        }
    };
    public static final DoubleDoubleFunction atan2 = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return Math.atan2(d, d2);
        }
    };
    public static final DoubleDoubleFunction compare = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d < d2 ? -1.0 : (d > d2 ? 1.0 : 0.0);
        }
    };
    public static final DoubleDoubleFunction div = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d / d2;
        }
    };
    public static final DoubleDoubleFunction divNeg = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return -(d / d2);
        }
    };
    public static final DoubleDoubleFunction equals = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d == d2 ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction greater = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d > d2 ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction IEEEremainder = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return Math.IEEEremainder(d, d2);
        }
    };
    public static final DoubleDoubleProcedure isEqual = new DoubleDoubleProcedure(){

        public final boolean apply(double d, double d2) {
            return d == d2;
        }
    };
    public static final DoubleDoubleProcedure isLess = new DoubleDoubleProcedure(){

        public final boolean apply(double d, double d2) {
            return d < d2;
        }
    };
    public static final DoubleDoubleProcedure isGreater = new DoubleDoubleProcedure(){

        public final boolean apply(double d, double d2) {
            return d > d2;
        }
    };
    public static final DoubleDoubleFunction less = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d < d2 ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction lg = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return Math.log(d) / Math.log(d2);
        }
    };
    public static final DoubleDoubleFunction max = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return Math.max(d, d2);
        }
    };
    public static final DoubleDoubleFunction min = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return Math.min(d, d2);
        }
    };
    public static final DoubleDoubleFunction minus = DoubleFunctions.plusMultSecond(-1.0);
    public static final DoubleDoubleFunction mod = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d % d2;
        }
    };
    public static final DoubleDoubleFunction mult = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d * d2;
        }
    };
    public static final DoubleDoubleFunction multNeg = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return -(d * d2);
        }
    };
    public static final DoubleDoubleFunction multSquare = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return d * d2 * d2;
        }
    };
    public static final DoubleDoubleFunction plus = DoubleFunctions.plusMultSecond(1.0);
    public static final DoubleDoubleFunction plusAbs = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return Math.abs(d) + Math.abs(d2);
        }
    };
    public static final DoubleDoubleFunction pow = new DoubleDoubleFunction(){

        public final double apply(double d, double d2) {
            return Math.pow(d, d2);
        }
    };

    protected DoubleFunctions() {
    }

    public static DoubleFunction between(final double d, final double d2) {
        return new DoubleFunction(){

            public final double apply(double d3) {
                return d <= d3 && d3 <= d2 ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction bindArg1(final DoubleDoubleFunction doubleDoubleFunction, final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return doubleDoubleFunction.apply(d, d2);
            }
        };
    }

    public static DoubleFunction bindArg2(final DoubleDoubleFunction doubleDoubleFunction, final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return doubleDoubleFunction.apply(d2, d);
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, final DoubleFunction doubleFunction2) {
        return new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return doubleDoubleFunction.apply(doubleFunction.apply(d), doubleFunction2.apply(d2));
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleFunction doubleFunction, final DoubleDoubleFunction doubleDoubleFunction) {
        return new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return doubleFunction.apply(doubleDoubleFunction.apply(d, d2));
            }
        };
    }

    public static DoubleFunction chain(final DoubleFunction doubleFunction, final DoubleFunction doubleFunction2) {
        return new DoubleFunction(){

            public final double apply(double d) {
                return doubleFunction.apply(doubleFunction2.apply(d));
            }
        };
    }

    public static DoubleFunction compare(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return d2 < d ? -1.0 : (d2 > d ? 1.0 : 0.0);
            }
        };
    }

    public static DoubleFunction constant(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return d;
            }
        };
    }

    public static void demo1() {
        DoubleFunctions doubleFunctions = functions;
        double d = 0.5;
        double d2 = 0.2;
        double d3 = Math.sin(d) + Math.pow(Math.cos(d2), 2.0);
        System.out.println(d3);
        DoubleDoubleFunction doubleDoubleFunction = DoubleFunctions.chain(plus, sin, DoubleFunctions.chain(square, cos));
        System.out.println(doubleDoubleFunction.apply(d, d2));
        DoubleDoubleFunction doubleDoubleFunction2 = new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return Math.sin(d) + Math.pow(Math.cos(d2), 2.0);
            }
        };
        System.out.println(doubleDoubleFunction2.apply(d, d2));
        DoubleFunction doubleFunction = DoubleFunctions.plus(3.0);
        DoubleFunction doubleFunction2 = DoubleFunctions.plus(4.0);
        System.out.println(doubleFunction.apply(0.0));
        System.out.println(doubleFunction2.apply(0.0));
    }

    public static void demo2(int n) {
        DoubleFunctions doubleFunctions = functions;
        System.out.println("\n\n");
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.abs(Math.sin(d) + Math.pow(Math.cos(d2), 2.0));
        System.out.println(d3);
        DoubleDoubleFunction doubleDoubleFunction = DoubleFunctions.chain(abs, DoubleFunctions.chain(plus, sin, DoubleFunctions.chain(square, cos)));
        System.out.println(doubleDoubleFunction.apply(d, d2));
        DoubleDoubleFunction doubleDoubleFunction2 = new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return Math.abs(Math.sin(d) + Math.pow(Math.cos(d2), 2.0));
            }
        };
        System.out.println(doubleDoubleFunction2.apply(d, d2));
        Timer timer = new Timer().start();
        d = 0.0;
        d2 = 0.0;
        double d4 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            d4 += d;
            d += 1.0;
            d2 += 1.0;
        }
        timer.stop().display();
        System.out.println("empty sum=" + d4);
        Timer timer2 = new Timer().start();
        d = 0.0;
        d2 = 0.0;
        d4 = 0.0;
        int n3 = n;
        while (--n3 >= 0) {
            d4 += Math.abs(Math.sin(d) + Math.pow(Math.cos(d2), 2.0));
            d += 1.0;
            d2 += 1.0;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (double)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + d4);
        timer2.reset().start();
        d = 0.0;
        d2 = 0.0;
        d4 = 0.0;
        n3 = n;
        while (--n3 >= 0) {
            d4 += doubleDoubleFunction.apply(d, d2);
            d += 1.0;
            d2 += 1.0;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (double)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + d4);
        timer2.reset().start();
        d = 0.0;
        d2 = 0.0;
        d4 = 0.0;
        n3 = n;
        while (--n3 >= 0) {
            d4 += doubleDoubleFunction2.apply(d, d2);
            d += 1.0;
            d2 += 1.0;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (double)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + d4);
    }

    public static DoubleFunction div(double d) {
        return DoubleFunctions.mult(1.0 / d);
    }

    public static DoubleFunction equals(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return d2 == d ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction greater(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return d2 > d ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction IEEEremainder(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return Math.IEEEremainder(d2, d);
            }
        };
    }

    public static DoubleProcedure isBetween(final double d, final double d2) {
        return new DoubleProcedure(){

            public final boolean apply(double d3) {
                return d <= d3 && d3 <= d2;
            }
        };
    }

    public static DoubleProcedure isEqual(final double d) {
        return new DoubleProcedure(){

            public final boolean apply(double d2) {
                return d2 == d;
            }
        };
    }

    public static DoubleProcedure isGreater(final double d) {
        return new DoubleProcedure(){

            public final boolean apply(double d2) {
                return d2 > d;
            }
        };
    }

    public static DoubleProcedure isLess(final double d) {
        return new DoubleProcedure(){

            public final boolean apply(double d2) {
                return d2 < d;
            }
        };
    }

    public static DoubleFunction less(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return d2 < d ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction lg(final double d) {
        return new DoubleFunction(){
            private final double logInv;
            {
                this.logInv = 1.0 / Math.log(d);
            }

            public final double apply(double d2) {
                return Math.log(d2) * this.logInv;
            }
        };
    }

    protected static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        DoubleFunctions.demo2(n);
    }

    public static DoubleFunction max(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return Math.max(d2, d);
            }
        };
    }

    public static DoubleFunction min(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return Math.min(d2, d);
            }
        };
    }

    public static DoubleFunction minus(double d) {
        return DoubleFunctions.plus(-d);
    }

    public static DoubleDoubleFunction minusMult(double d) {
        return DoubleFunctions.plusMultSecond(-d);
    }

    public static DoubleFunction mod(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return d2 % d;
            }
        };
    }

    public static DoubleFunction mult(double d) {
        return new DoubleMult(d);
    }

    public static DoubleFunction plus(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return d2 + d;
            }
        };
    }

    public static DoubleDoubleFunction multSecond(final double d) {
        return new DoubleDoubleFunction(){

            public final double apply(double d3, double d2) {
                return d2 * d;
            }
        };
    }

    public static DoubleDoubleFunction plusMultSecond(double d) {
        return new DoublePlusMultSecond(d);
    }

    public static DoubleDoubleFunction plusMultFirst(double d) {
        return new DoublePlusMultFirst(d);
    }

    public static DoubleFunction pow(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return Math.pow(d2, d);
            }
        };
    }

    public static DoubleFunction random() {
        return new RandomDoubleFunction();
    }

    public static DoubleFunction round(final double d) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return Math.rint(d2 / d) * d;
            }
        };
    }

    public static DoubleDoubleFunction swapArgs(final DoubleDoubleFunction doubleDoubleFunction) {
        return new DoubleDoubleFunction(){

            public final double apply(double d, double d2) {
                return doubleDoubleFunction.apply(d2, d);
            }
        };
    }

    private static class RandomDoubleFunction
    implements DoubleFunction {
        private RandomDoubleFunction() {
        }

        public double apply(double d) {
            return Math.random();
        }
    }
}

