/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.PersistentObject;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix2D;

public class ObjectFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final ObjectFactory2D dense = new ObjectFactory2D();
    public static final ObjectFactory2D sparse = new ObjectFactory2D();

    protected ObjectFactory2D() {
    }

    public ObjectMatrix2D appendColumns(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2) {
        if (objectMatrix2D2.rows() > objectMatrix2D.rows()) {
            objectMatrix2D2 = objectMatrix2D2.viewPart(0, 0, objectMatrix2D.rows(), objectMatrix2D2.columns());
        } else if (objectMatrix2D2.rows() < objectMatrix2D.rows()) {
            objectMatrix2D = objectMatrix2D.viewPart(0, 0, objectMatrix2D2.rows(), objectMatrix2D.columns());
        }
        int n = objectMatrix2D.columns();
        int n2 = objectMatrix2D2.columns();
        int n3 = objectMatrix2D.rows();
        ObjectMatrix2D objectMatrix2D3 = this.make(n3, n + n2);
        objectMatrix2D3.viewPart(0, 0, n3, n).assign(objectMatrix2D);
        objectMatrix2D3.viewPart(0, n, n3, n2).assign(objectMatrix2D2);
        return objectMatrix2D3;
    }

    public ObjectMatrix2D appendRows(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2) {
        if (objectMatrix2D2.columns() > objectMatrix2D.columns()) {
            objectMatrix2D2 = objectMatrix2D2.viewPart(0, 0, objectMatrix2D2.rows(), objectMatrix2D.columns());
        } else if (objectMatrix2D2.columns() < objectMatrix2D.columns()) {
            objectMatrix2D = objectMatrix2D.viewPart(0, 0, objectMatrix2D.rows(), objectMatrix2D2.columns());
        }
        int n = objectMatrix2D.rows();
        int n2 = objectMatrix2D2.rows();
        int n3 = objectMatrix2D.columns();
        ObjectMatrix2D objectMatrix2D3 = this.make(n + n2, n3);
        objectMatrix2D3.viewPart(0, 0, n, n3).assign(objectMatrix2D);
        objectMatrix2D3.viewPart(n, 0, n2, n3).assign(objectMatrix2D2);
        return objectMatrix2D3;
    }

    protected static void checkRectangularShape(ObjectMatrix2D[][] objectMatrix2DArray) {
        int n = -1;
        int n2 = objectMatrix2DArray.length;
        while (--n2 >= 0) {
            if (objectMatrix2DArray[n2] == null) continue;
            if (n == -1) {
                n = objectMatrix2DArray[n2].length;
            }
            if (objectMatrix2DArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(Object[][] objectArray) {
        int n = -1;
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            if (objectArray[n2] == null) continue;
            if (n == -1) {
                n = objectArray[n2].length;
            }
            if (objectArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public ObjectMatrix2D compose(ObjectMatrix2D[][] objectMatrix2DArray) {
        int n;
        int n2;
        int n3;
        ObjectFactory2D.checkRectangularShape(objectMatrix2DArray);
        int n4 = objectMatrix2DArray.length;
        int n5 = 0;
        if (objectMatrix2DArray.length > 0) {
            n5 = objectMatrix2DArray[0].length;
        }
        ObjectMatrix2D objectMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return objectMatrix2D;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                ObjectMatrix2D objectMatrix2D2 = objectMatrix2DArray[n2][n6];
                if (objectMatrix2D2 == null) continue;
                int n7 = objectMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                ObjectMatrix2D objectMatrix2D3 = objectMatrix2DArray[n3][n8];
                if (objectMatrix2D3 == null) continue;
                n = objectMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        ObjectMatrix2D objectMatrix2D4 = this.make(n3, n2);
        int n10 = 0;
        for (n = 0; n < n4; ++n) {
            int n11 = 0;
            for (int i = 0; i < n5; ++i) {
                ObjectMatrix2D objectMatrix2D5 = objectMatrix2DArray[n][i];
                if (objectMatrix2D5 != null) {
                    objectMatrix2D4.viewPart(n10, n11, objectMatrix2D5.rows(), objectMatrix2D5.columns()).assign(objectMatrix2D5);
                }
                n11 += nArray[i];
            }
            n10 += nArray2[n];
        }
        return objectMatrix2D4;
    }

    public ObjectMatrix2D composeDiagonal(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2) {
        int n = objectMatrix2D.rows();
        int n2 = objectMatrix2D.columns();
        int n3 = objectMatrix2D2.rows();
        int n4 = objectMatrix2D2.columns();
        ObjectMatrix2D objectMatrix2D3 = this.make(n + n3, n2 + n4);
        objectMatrix2D3.viewPart(0, 0, n, n2).assign(objectMatrix2D);
        objectMatrix2D3.viewPart(n, n2, n3, n4).assign(objectMatrix2D2);
        return objectMatrix2D3;
    }

    public ObjectMatrix2D composeDiagonal(ObjectMatrix2D objectMatrix2D, ObjectMatrix2D objectMatrix2D2, ObjectMatrix2D objectMatrix2D3) {
        ObjectMatrix2D objectMatrix2D4 = this.make(objectMatrix2D.rows() + objectMatrix2D2.rows() + objectMatrix2D3.rows(), objectMatrix2D.columns() + objectMatrix2D2.columns() + objectMatrix2D3.columns());
        objectMatrix2D4.viewPart(0, 0, objectMatrix2D.rows(), objectMatrix2D.columns()).assign(objectMatrix2D);
        objectMatrix2D4.viewPart(objectMatrix2D.rows(), objectMatrix2D.columns(), objectMatrix2D2.rows(), objectMatrix2D2.columns()).assign(objectMatrix2D2);
        objectMatrix2D4.viewPart(objectMatrix2D.rows() + objectMatrix2D2.rows(), objectMatrix2D.columns() + objectMatrix2D2.columns(), objectMatrix2D3.rows(), objectMatrix2D3.columns()).assign(objectMatrix2D3);
        return objectMatrix2D4;
    }

    public void decompose(ObjectMatrix2D[][] objectMatrix2DArray, ObjectMatrix2D objectMatrix2D) {
        int n;
        int n2;
        int n3;
        ObjectFactory2D.checkRectangularShape(objectMatrix2DArray);
        int n4 = objectMatrix2DArray.length;
        int n5 = 0;
        if (objectMatrix2DArray.length > 0) {
            n5 = objectMatrix2DArray[0].length;
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                ObjectMatrix2D objectMatrix2D2 = objectMatrix2DArray[n2][n6];
                if (objectMatrix2D2 == null) continue;
                int n7 = objectMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                ObjectMatrix2D objectMatrix2D3 = objectMatrix2DArray[n3][n8];
                if (objectMatrix2D3 == null) continue;
                n = objectMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        if (objectMatrix2D.rows() < n3 || objectMatrix2D.columns() < n2) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        n9 = 0;
        for (int i = 0; i < n4; ++i) {
            n = 0;
            for (int j = 0; j < n5; ++j) {
                ObjectMatrix2D objectMatrix2D4 = objectMatrix2DArray[i][j];
                if (objectMatrix2D4 != null) {
                    objectMatrix2D4.assign(objectMatrix2D.viewPart(n9, n, objectMatrix2D4.rows(), objectMatrix2D4.columns()));
                }
                n += nArray[j];
            }
            n9 += nArray2[i];
        }
    }

    public ObjectMatrix2D diagonal(ObjectMatrix1D objectMatrix1D) {
        int n = (int)objectMatrix1D.size();
        ObjectMatrix2D objectMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            objectMatrix2D.setQuick(n2, n2, objectMatrix1D.getQuick(n2));
        }
        return objectMatrix2D;
    }

    public ObjectMatrix1D diagonal(ObjectMatrix2D objectMatrix2D) {
        int n = Math.min(objectMatrix2D.rows(), objectMatrix2D.columns());
        ObjectMatrix1D objectMatrix1D = this.make1D(n);
        int n2 = n;
        while (--n2 >= 0) {
            objectMatrix1D.setQuick(n2, objectMatrix2D.getQuick(n2, n2));
        }
        return objectMatrix1D;
    }

    public ObjectMatrix2D make(Object[][] objectArray) {
        if (this == sparse) {
            return new SparseObjectMatrix2D(objectArray);
        }
        return new DenseObjectMatrix2D(objectArray);
    }

    public ObjectMatrix2D make(Object[] objectArray, int n) {
        int n2;
        int n3 = n2 = n != 0 ? objectArray.length / n : 0;
        if (n * n2 != objectArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        ObjectMatrix2D objectMatrix2D = this.make(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectMatrix2D.setQuick(i, j, objectArray[i + j * n]);
            }
        }
        return objectMatrix2D;
    }

    public ObjectMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseObjectMatrix2D(n, n2);
        }
        return new DenseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix2D make(int n, int n2, Object object) {
        if (object == null) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(object);
    }

    protected ObjectMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public ObjectMatrix2D repeat(ObjectMatrix2D objectMatrix2D, int n, int n2) {
        int n3 = objectMatrix2D.rows();
        int n4 = objectMatrix2D.columns();
        ObjectMatrix2D objectMatrix2D2 = this.make(n3 * n, n4 * n2);
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                objectMatrix2D2.viewPart(n3 * n5, n4 * n6, n3, n4).assign(objectMatrix2D);
            }
        }
        return objectMatrix2D2;
    }
}

