/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongLongProcedure;
import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.map.tlong.OpenLongLongHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedSparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCMLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCMLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultSecond;
import java.io.IOException;

public class SparseLongMatrix2D
extends LongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;

    public SparseLongMatrix2D(long[][] lArray) {
        this(lArray.length, lArray.length == 0 ? 0 : lArray[0].length);
        this.assign(lArray);
    }

    public SparseLongMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2, 0.5);
    }

    public SparseLongMatrix2D(int n, int n2, int n3, double d, double d2) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongLongHashMap(n3, d, d2);
    }

    public SparseLongMatrix2D(int n, int n2, int[] nArray, int[] nArray2, long l) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongLongHashMap(nArray.length);
        this.insert(nArray, nArray2, l);
    }

    public SparseLongMatrix2D(int n, int n2, int[] nArray, int[] nArray2, long[] lArray) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongLongHashMap(nArray.length);
        this.insert(nArray, nArray2, lArray);
    }

    public SparseLongMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block9: {
            long[] lArray;
            int[] nArray;
            int[] nArray2;
            int n;
            MatrixInfo matrixInfo;
            block8: {
                MatrixSize matrixSize;
                block7: {
                    matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (matrixInfo.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (matrixInfo.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (matrixInfo.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                    try {
                        this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                        throw illegalArgumentException;
                    }
                }
                n = matrixSize.numEntries();
                nArray2 = new int[n];
                nArray = new int[n];
                lArray = new long[n];
                matrixVectorReader.readCoordinate(nArray, nArray2, lArray);
                this.elements = matrixInfo.isSymmetric() || matrixInfo.isSkewSymmetric() ? new OpenLongLongHashMap(2 * nArray.length) : new OpenLongLongHashMap(nArray.length);
                this.insert(nArray, nArray2, lArray);
                if (!matrixInfo.isSymmetric()) break block8;
                for (int i = 0; i < n; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    this.set(nArray2[i], nArray[i], lArray[i]);
                }
                break block9;
            }
            if (!matrixInfo.isSkewSymmetric()) break block9;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                this.set(nArray2[i], nArray[i], -lArray[i]);
            }
        }
    }

    protected SparseLongMatrix2D(int n, int n2, AbstractLongLongMap abstractLongLongMap, int n3, int n4, int n5, int n6) {
        block2: {
            try {
                this.setUp(n, n2, n3, n4, n5, n6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = abstractLongLongMap;
        this.isNoView = false;
    }

    public LongMatrix2D assign(LongFunction longFunction) {
        if (this.isNoView && longFunction instanceof LongMult) {
            this.elements.assign(longFunction);
        } else {
            super.assign(longFunction);
        }
        return this;
    }

    public LongMatrix2D assign(long l) {
        if (this.isNoView && l == 0L) {
            this.elements.clear();
        } else {
            super.assign(l);
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D) {
        if (!(longMatrix2D instanceof SparseLongMatrix2D)) {
            return super.assign(longMatrix2D);
        }
        SparseLongMatrix2D sparseLongMatrix2D = (SparseLongMatrix2D)longMatrix2D;
        if (sparseLongMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseLongMatrix2D);
        if (this.isNoView && sparseLongMatrix2D.isNoView) {
            this.elements.assign(sparseLongMatrix2D.elements);
            return this;
        }
        return super.assign(longMatrix2D);
    }

    public LongMatrix2D assign(final LongMatrix2D longMatrix2D, LongLongFunction longLongFunction) {
        if (!this.isNoView) {
            return super.assign(longMatrix2D, longLongFunction);
        }
        this.checkShape(longMatrix2D);
        if (longLongFunction instanceof LongPlusMultSecond) {
            final long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
            if (l == 0L) {
                return this;
            }
            longMatrix2D.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l2) {
                    SparseLongMatrix2D.this.setQuick(n, n2, SparseLongMatrix2D.this.getQuick(n, n2) + l * l2);
                    return l2;
                }
            });
        } else if (longLongFunction == LongFunctions.mult) {
            this.elements.forEachPair(new LongLongProcedure(){

                public boolean apply(long l, long l2) {
                    int n;
                    int n2 = (int)(l / (long)SparseLongMatrix2D.this.columns);
                    long l3 = l2 * longMatrix2D.getQuick(n2, n = (int)(l % (long)SparseLongMatrix2D.this.columns));
                    if (l3 != l2) {
                        SparseLongMatrix2D.this.elements.put(l, l3);
                    }
                    return true;
                }
            });
        } else if (longLongFunction == LongFunctions.div) {
            this.elements.forEachPair(new LongLongProcedure(){

                public boolean apply(long l, long l2) {
                    int n;
                    int n2 = (int)(l / (long)SparseLongMatrix2D.this.columns);
                    long l3 = l2 / longMatrix2D.getQuick(n2, n = (int)(l % (long)SparseLongMatrix2D.this.columns));
                    if (l3 != l2) {
                        SparseLongMatrix2D.this.elements.put(l, l3);
                    }
                    return true;
                }
            });
        } else {
            super.assign(longMatrix2D, longLongFunction);
        }
        return this;
    }

    public SparseLongMatrix2D assign(int[] nArray, int[] nArray2, long l, LongLongFunction longLongFunction) {
        int n = nArray.length;
        if (longLongFunction == LongFunctions.plus) {
            for (int i = 0; i < n; ++i) {
                long l2 = nArray[i];
                long l3 = nArray2[i];
                if (l2 >= (long)this.rows || l3 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l2 + ", column: " + l3);
                }
                long l4 = (long)this.rowZero + l2 * (long)this.rowStride + (long)this.columnZero + l3 * (long)this.columnStride;
                long l5 = this.elements.get(l4);
                long l6 = l5 + l;
                if (l6 != 0L) {
                    this.elements.put(l4, l6);
                    continue;
                }
                this.elements.removeKey(l4);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                long l7 = nArray[i];
                long l8 = nArray2[i];
                if (l7 >= (long)this.rows || l8 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l7 + ", column: " + l8);
                }
                long l9 = (long)this.rowZero + l7 * (long)this.rowStride + (long)this.columnZero + l8 * (long)this.columnStride;
                long l10 = this.elements.get(l9);
                long l11 = longLongFunction.apply(l10, l);
                if (l11 != 0L) {
                    this.elements.put(l9, l11);
                    continue;
                }
                this.elements.removeKey(l9);
            }
        }
        return this;
    }

    public SparseLongMatrix2D assign(int[] nArray, int[] nArray2, long[] lArray, LongLongFunction longLongFunction) {
        int n = nArray.length;
        if (longLongFunction == LongFunctions.plus) {
            for (int i = 0; i < n; ++i) {
                long l = lArray[i];
                long l2 = nArray[i];
                long l3 = nArray2[i];
                if (l2 >= (long)this.rows || l3 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l2 + ", column: " + l3);
                }
                long l4 = (long)this.rowZero + l2 * (long)this.rowStride + (long)this.columnZero + l3 * (long)this.columnStride;
                long l5 = this.elements.get(l4);
                if ((l += l5) != 0L) {
                    this.elements.put(l4, l);
                    continue;
                }
                this.elements.removeKey(l4);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                long l = lArray[i];
                long l6 = nArray[i];
                long l7 = nArray2[i];
                if (l6 >= (long)this.rows || l7 >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + l6 + ", column: " + l7);
                }
                long l8 = (long)this.rowZero + l6 * (long)this.rowStride + (long)this.columnZero + l7 * (long)this.columnStride;
                long l9 = this.elements.get(l8);
                l = longLongFunction.apply(l9, l);
                if (l != 0L) {
                    this.elements.put(l8, l);
                    continue;
                }
                this.elements.removeKey(l8);
            }
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCLongMatrix2D getColumnCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        long[] lArray2 = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseCCLongMatrix2D(this.rows, this.columns, nArray, nArray2, lArray2, false, false, bl);
    }

    public SparseCCMLongMatrix2D getColumnCompressedModified() {
        SparseCCMLongMatrix2D sparseCCMLongMatrix2D = new SparseCCMLongMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        long[] lArray2 = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseCCMLongMatrix2D.setQuick(n2, n3, lArray2[i]);
        }
        return sparseCCMLongMatrix2D;
    }

    public SparseRCLongMatrix2D getRowCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        long[] lArray2 = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseRCLongMatrix2D(this.rows, this.columns, nArray, nArray2, lArray2, false, false, bl);
    }

    public SparseRCMLongMatrix2D getRowCompressedModified() {
        SparseRCMLongMatrix2D sparseRCMLongMatrix2D = new SparseRCMLongMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        long[] lArray2 = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseRCMLongMatrix2D.setQuick(n2, n3, lArray2[i]);
        }
        return sparseRCMLongMatrix2D;
    }

    public AbstractLongLongMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public LongMatrix2D forEachNonZero(final IntIntLongFunction intIntLongFunction) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongLongProcedure(){

                public boolean apply(long l, long l2) {
                    int n;
                    int n2 = (int)(l / (long)SparseLongMatrix2D.this.columns);
                    long l3 = intIntLongFunction.apply(n2, n = (int)(l % (long)SparseLongMatrix2D.this.columns), l2);
                    if (l3 != l2) {
                        SparseLongMatrix2D.this.elements.put(l, l3);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(intIntLongFunction);
        }
        return this;
    }

    public synchronized long getQuick(int n, int n2) {
        return this.elements.get((long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride);
    }

    public long index(int n, int n2) {
        return (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
    }

    public LongMatrix2D like(int n, int n2) {
        return new SparseLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new SparseLongMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, long l) {
        long l2 = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (l == 0L) {
            this.elements.removeKey(l2);
        } else {
            this.elements.put(l2, l);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                long l = this.getQuick(i, j);
                if (l == 0L) continue;
                stringBuilder.append('(').append(i).append(',').append(j).append(')').append('\t').append(l).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public LongMatrix1D vectorize() {
        SparseLongMatrix1D sparseLongMatrix1D = new SparseLongMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                long l = this.getQuick(j, i);
                sparseLongMatrix1D.setQuick(n++, l);
            }
        }
        return sparseLongMatrix1D;
    }

    public LongMatrix1D zMult(LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2, final long l, long l2, final boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = longMatrix1D2 == null;
        if (longMatrix1D2 == null) {
            longMatrix1D2 = new DenseLongMatrix1D(n);
        }
        if (!(this.isNoView && longMatrix1D instanceof DenseLongMatrix1D && longMatrix1D2 instanceof DenseLongMatrix1D)) {
            return super.zMult(longMatrix1D, longMatrix1D2, l, l2, bl);
        }
        if ((long)n2 != longMatrix1D.size() || (long)n > longMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + longMatrix1D.toStringShort() + ", " + longMatrix1D2.toStringShort());
        }
        if (!bl2) {
            longMatrix1D2.assign(LongFunctions.mult(l2));
        }
        DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D2;
        final long[] lArray = denseLongMatrix1D.elements;
        final int n3 = denseLongMatrix1D.stride();
        final int n4 = (int)longMatrix1D2.index(0);
        DenseLongMatrix1D denseLongMatrix1D2 = (DenseLongMatrix1D)longMatrix1D;
        final long[] lArray2 = denseLongMatrix1D2.elements;
        final int n5 = denseLongMatrix1D2.stride();
        final int n6 = (int)longMatrix1D.index(0);
        if (lArray2 == null || lArray == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongLongProcedure(){

            public boolean apply(long l3, long l2) {
                int n = (int)(l3 / (long)SparseLongMatrix2D.this.columns);
                int n2 = (int)(l3 % (long)SparseLongMatrix2D.this.columns);
                if (bl) {
                    int n32 = n;
                    n = n2;
                    n2 = n32;
                }
                int n42 = n4 + n3 * n;
                lArray[n42] = lArray[n42] + l * l2 * lArray2[n6 + n5 * n2];
                return true;
            }
        });
        return longMatrix1D2;
    }

    public LongMatrix2D zMult(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2, final long l, long l2, final boolean bl, boolean bl2) {
        boolean bl3;
        if (!this.isNoView) {
            return super.zMult(longMatrix2D, longMatrix2D2, l, l2, bl, bl2);
        }
        if (bl2) {
            longMatrix2D = longMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = longMatrix2D.columns();
        boolean bl4 = bl3 = longMatrix2D2 == null;
        if (longMatrix2D2 == null) {
            longMatrix2D2 = new DenseLongMatrix2D(n, n3);
        }
        if (longMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? longMatrix2D.viewDice() : longMatrix2D).toStringShort());
        }
        if (longMatrix2D2.rows() != n || longMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? longMatrix2D.viewDice() : longMatrix2D).toStringShort() + ", " + longMatrix2D2.toStringShort());
        }
        if (this == longMatrix2D2 || longMatrix2D == longMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            longMatrix2D2.assign(LongFunctions.mult(l2));
        }
        final LongMatrix1D[] longMatrix1DArray = new LongMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            longMatrix1DArray[n4] = longMatrix2D.viewRow(n4);
        }
        final LongMatrix1D[] longMatrix1DArray2 = new LongMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            longMatrix1DArray2[n5] = longMatrix2D2.viewRow(n5);
        }
        final LongPlusMultSecond longPlusMultSecond = LongPlusMultSecond.plusMult(0L);
        this.elements.forEachPair(new LongLongProcedure(){

            public boolean apply(long l3, long l2) {
                int n = (int)(l3 / (long)SparseLongMatrix2D.this.columns);
                int n2 = (int)(l3 % (long)SparseLongMatrix2D.this.columns);
                longPlusMultSecond.multiplicator = l2 * l;
                if (!bl) {
                    longMatrix1DArray2[n].assign(longMatrix1DArray[n2], longPlusMultSecond);
                } else {
                    longMatrix1DArray2[n2].assign(longMatrix1DArray[n], longPlusMultSecond);
                }
                return true;
            }
        });
        return longMatrix2D2;
    }

    private void insert(int[] nArray, int[] nArray2, long l) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l2 = nArray[i];
            long l3 = nArray2[i];
            if (l2 >= (long)this.rows || l3 >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + l2 + ", column: " + l3);
            }
            if (l == 0L) continue;
            long l4 = (long)this.rowZero + l2 * (long)this.rowStride + (long)this.columnZero + l3 * (long)this.columnStride;
            long l5 = this.elements.get(l4);
            if (l5 == 0L) {
                this.elements.put(l4, l);
                continue;
            }
            long l6 = l5 + l;
            if (l6 == 0L) {
                this.elements.removeKey(l4);
                continue;
            }
            this.elements.put(l4, l6);
        }
    }

    private void insert(int[] nArray, int[] nArray2, long[] lArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            long l2 = nArray[i];
            long l3 = nArray2[i];
            if (l2 >= (long)this.rows || l3 >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + l2 + ", column: " + l3);
            }
            if (l == 0L) continue;
            long l4 = (long)this.rowZero + l2 * (long)this.rowStride + (long)this.columnZero + l3 * (long)this.columnStride;
            long l5 = this.elements.get(l4);
            if (l5 == 0L) {
                this.elements.put(l4, l);
                continue;
            }
            long l6 = l5 + l;
            if (l6 == 0L) {
                this.elements.removeKey(l4);
                continue;
            }
            this.elements.put(l4, l6);
        }
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D longMatrix2D) {
        if (longMatrix2D instanceof SelectedSparseLongMatrix2D) {
            SelectedSparseLongMatrix2D selectedSparseLongMatrix2D = (SelectedSparseLongMatrix2D)longMatrix2D;
            return this.elements == selectedSparseLongMatrix2D.elements;
        }
        if (longMatrix2D instanceof SparseLongMatrix2D) {
            SparseLongMatrix2D sparseLongMatrix2D = (SparseLongMatrix2D)longMatrix2D;
            return this.elements == sparseLongMatrix2D.elements;
        }
        return false;
    }

    protected LongMatrix1D like1D(int n, int n2, int n3) {
        return new SparseLongMatrix1D(n, this.elements, n2, n3);
    }

    protected LongMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseLongMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

