/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;

public class SparseRCMIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseIntMatrix1D[] elements;

    public SparseRCMIntMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseIntMatrix1D[n];
        for (int i = 0; i < n; ++i) {
            this.elements[i] = new SparseIntMatrix1D(n2);
        }
    }

    public SparseIntMatrix1D[] elements() {
        return this.elements;
    }

    public int getQuick(int n, int n2) {
        return this.elements[n].getQuick(n2);
    }

    public void setQuick(int n, int n2, int n3) {
        this.elements[n].setQuick(n2, n3);
    }

    public void trimToSize() {
        for (int i = 0; i < this.rows; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseIntMatrix1D viewRow(int n) {
        return this.elements[n];
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseRCMIntMatrix2D(n, n2);
    }
}

