/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.Float9Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFloatMatrix2D
extends FloatMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    private FloatDCT_2D dct2;
    private FloatDST_2D dst2;
    private FloatDHT_2D dht2;
    protected float[] elements;

    public DenseFloatMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public DenseFloatMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new float[n * n2];
    }

    public DenseFloatMatrix2D(int n, int n2, float[] fArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = fArray;
        this.isNoView = !bl;
    }

    public DenseFloatMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block7: {
            int n;
            float[] fArray;
            int[] nArray;
            int[] nArray2;
            int n2;
            MatrixInfo matrixInfo;
            block6: {
                matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (matrixInfo.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (matrixInfo.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (matrixInfo.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                this.elements = new float[this.rows * this.columns];
                n2 = matrixSize.numEntries();
                nArray2 = new int[n2];
                nArray = new int[n2];
                fArray = new float[n2];
                matrixVectorReader.readCoordinate(nArray, nArray2, fArray);
                for (n = 0; n < n2; ++n) {
                    this.setQuick(nArray[n], nArray2[n], fArray[n]);
                }
                if (!matrixInfo.isSymmetric()) break block6;
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.setQuick(nArray2[n], nArray[n], fArray[n]);
                }
                break block7;
            }
            if (!matrixInfo.isSkewSymmetric()) break block7;
            for (n = 0; n < n2; ++n) {
                if (nArray[n] == nArray2[n]) continue;
                this.setQuick(nArray2[n], nArray[n], -fArray[n]);
            }
        }
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(DenseFloatMatrix2D.this.elements[n + (n4 - 1) * DenseFloatMatrix2D.this.rowStride + (DenseFloatMatrix2D.this.columns - 1) * DenseFloatMatrix2D.this.columnStride]);
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseFloatMatrix2D.this.rowStride;
                            int n42 = DenseFloatMatrix2D.this.columns - n6;
                            while (--n42 >= 0) {
                                f = floatFloatFunction.apply(f, floatFunction.apply(DenseFloatMatrix2D.this.elements[n3 + n42 * DenseFloatMatrix2D.this.columnStride]));
                            }
                            n6 = 0;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int n6 = 1;
            int n7 = this.rows;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.rowStride;
                int n9 = this.columns - n6;
                while (--n9 >= 0) {
                    f = floatFloatFunction.apply(f, floatFunction.apply(this.elements[n8 + n9 * this.columnStride]));
                }
                n6 = 0;
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, final FloatProcedure floatProcedure) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = DenseFloatMatrix2D.this.elements[n + n4 * DenseFloatMatrix2D.this.rowStride];
                        float f2 = 0.0f;
                        if (floatProcedure.apply(f)) {
                            f2 = floatFunction.apply(f);
                        }
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = n2; j < DenseFloatMatrix2D.this.columns; ++j) {
                                f = DenseFloatMatrix2D.this.elements[n + i * DenseFloatMatrix2D.this.rowStride + j * DenseFloatMatrix2D.this.columnStride];
                                if (!floatProcedure.apply(f)) continue;
                                f2 = floatFloatFunction.apply(f2, floatFunction.apply(f));
                            }
                            n2 = 0;
                        }
                        return Float.valueOf(f2);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            float f2 = this.elements[n];
            if (floatProcedure.apply(f2)) {
                f = floatFunction.apply(this.elements[n]);
            }
            int n6 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n6; j < this.columns; ++j) {
                    f2 = this.elements[n + i * this.rowStride + j * this.columnStride];
                    if (!floatProcedure.apply(f2)) continue;
                    f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                }
                n6 = 0;
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        float f = 0.0f;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, n2);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFunction.apply(DenseFloatMatrix2D.this.elements[n + nArray[n5] * DenseFloatMatrix2D.this.rowStride + nArray2[n5] * DenseFloatMatrix2D.this.columnStride]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            float f2 = DenseFloatMatrix2D.this.elements[n + nArray[i] * DenseFloatMatrix2D.this.rowStride + nArray2[i] * DenseFloatMatrix2D.this.columnStride];
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFunction.apply(this.elements[n + nArray[0] * this.rowStride + nArray2[0] * this.columnStride]);
            for (int i = 1; i < n2; ++i) {
                float f2 = this.elements[n + nArray[i] * this.rowStride + nArray2[i] * this.columnStride];
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
        }
        return f;
    }

    public float aggregate(FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction, final FloatFloatFunction floatFloatFunction2) {
        if (!(floatMatrix2D instanceof DenseFloatMatrix2D)) {
            return super.aggregate(floatMatrix2D, floatFloatFunction, floatFloatFunction2);
        }
        this.checkShape(floatMatrix2D);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)floatMatrix2D.index(0, 0);
        final int n3 = floatMatrix2D.rowStride();
        final int n4 = floatMatrix2D.columnStride();
        final float[] fArray = (float[])floatMatrix2D.elements();
        float f = 0.0f;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = floatFloatFunction2.apply(DenseFloatMatrix2D.this.elements[n + n7 * DenseFloatMatrix2D.this.rowStride], fArray[n2 + n7 * n3]);
                        int n5 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n5; j < DenseFloatMatrix2D.this.columns; ++j) {
                                f = floatFloatFunction.apply(f, floatFloatFunction2.apply(DenseFloatMatrix2D.this.elements[n + i * DenseFloatMatrix2D.this.rowStride + j * DenseFloatMatrix2D.this.columnStride], fArray[n2 + i * n3 + j * n4]));
                            }
                            n5 = 0;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            int n9 = 1;
            f = floatFloatFunction2.apply(this.elements[n], fArray[n2]);
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    f = floatFloatFunction.apply(f, floatFloatFunction2.apply(this.elements[n + i * this.rowStride + j * this.columnStride], fArray[n2 + i * n3 + j * n4]));
                }
                n9 = 0;
            }
        }
        return f;
    }

    public FloatMatrix2D assign(final FloatFunction floatFunction) {
        final float[] fArray = this.elements;
        if (fArray == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (floatFunction instanceof FloatMult) {
                float f = ((FloatMult)floatFunction).multiplicator;
                if (f == 1.0f) {
                    return this;
                }
                if (f == 0.0f) {
                    return this.assign(0.0f);
                }
            }
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + n4 * DenseFloatMatrix2D.this.rowStride;
                        if (floatFunction instanceof FloatMult) {
                            float f = ((FloatMult)floatFunction).multiplicator;
                            if (f == 1.0f) {
                                return;
                            }
                            for (int i = n4; i < n5; ++i) {
                                int n2 = n6;
                                for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                    int n3 = n2;
                                    fArray[n3] = fArray[n3] * f;
                                    n2 += DenseFloatMatrix2D.this.columnStride;
                                }
                                n6 += DenseFloatMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int i = n4; i < n5; ++i) {
                                int n42 = n6;
                                for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                    fArray[n42] = floatFunction.apply(fArray[n42]);
                                    n42 += DenseFloatMatrix2D.this.columnStride;
                                }
                                n6 += DenseFloatMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (floatFunction instanceof FloatMult) {
                float f = ((FloatMult)floatFunction).multiplicator;
                if (f == 1.0f) {
                    return this;
                }
                if (f == 0.0f) {
                    return this.assign(0.0f);
                }
                int n7 = this.rows;
                while (--n7 >= 0) {
                    int n8 = n6;
                    int n9 = this.columns;
                    while (--n9 >= 0) {
                        int n10 = n8;
                        fArray[n10] = fArray[n10] * f;
                        n8 -= this.columnStride;
                    }
                    n6 -= this.rowStride;
                }
            } else {
                int n11 = this.rows;
                while (--n11 >= 0) {
                    int n12 = n6;
                    int n13 = this.columns;
                    while (--n13 >= 0) {
                        fArray[n12] = floatFunction.apply(fArray[n12]);
                        n12 -= this.columnStride;
                    }
                    n6 -= this.rowStride;
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure floatProcedure, final FloatFunction floatFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseFloatMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                float f = DenseFloatMatrix2D.this.elements[n2];
                                if (floatProcedure.apply(f)) {
                                    DenseFloatMatrix2D.this.elements[n2] = floatFunction.apply(f);
                                }
                                n2 += DenseFloatMatrix2D.this.columnStride;
                            }
                            n3 += DenseFloatMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    float f = this.elements[n7];
                    if (floatProcedure.apply(f)) {
                        this.elements[n7] = floatFunction.apply(f);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final FloatProcedure floatProcedure, final float f) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseFloatMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                float f2 = DenseFloatMatrix2D.this.elements[n2];
                                if (floatProcedure.apply(f2)) {
                                    DenseFloatMatrix2D.this.elements[n2] = f;
                                }
                                n2 += DenseFloatMatrix2D.this.columnStride;
                            }
                            n3 += DenseFloatMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    float f2 = this.elements[n7];
                    if (floatProcedure.apply(f2)) {
                        this.elements[n7] = f;
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float f) {
        final float[] fArray = this.elements;
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseFloatMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                fArray[n2] = f;
                                n2 += DenseFloatMatrix2D.this.columnStride;
                            }
                            n3 += DenseFloatMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    fArray[n7] = f;
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[] fArray) {
        if ((long)fArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n3 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n - 1 ? this.rows : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n4 * DenseFloatMatrix2D.this.columns;
                            int n22 = n2 + n4 * DenseFloatMatrix2D.this.rowStride;
                            for (int i = n4; i < n5; ++i) {
                                int n3 = n22;
                                for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                    DenseFloatMatrix2D.this.elements[n3] = fArray[n++];
                                    n3 += DenseFloatMatrix2D.this.columnStride;
                                }
                                n22 += DenseFloatMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = 0;
                int n7 = n2;
                for (int i = 0; i < this.rows; ++i) {
                    int n8 = n7;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n8] = fArray[n6++];
                        n8 += this.columnStride;
                    }
                    n7 += this.rowStride;
                }
            }
        }
        return this;
    }

    public FloatMatrix2D assign(final float[][] fArray) {
        if (fArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + fArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n2 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n3 = i * n2;
                    final int n4 = i == n - 1 ? this.rows : n3 + n2;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n3 * DenseFloatMatrix2D.this.rowStride;
                            for (int i = n3; i < n4; ++i) {
                                float[] fArray2 = fArray[i];
                                if (fArray2.length != DenseFloatMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + DenseFloatMatrix2D.this.columns());
                                }
                                System.arraycopy(fArray2, 0, DenseFloatMatrix2D.this.elements, n, DenseFloatMatrix2D.this.columns);
                                n += DenseFloatMatrix2D.this.columns;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n5 = 0;
                for (int i = 0; i < this.rows; ++i) {
                    float[] fArray2 = fArray[i];
                    if (fArray2.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(fArray2, 0, this.elements, n5, this.columns);
                    n5 += this.columns;
                }
            }
        } else {
            final int n6 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.rows);
                Future[] futureArray = new Future[n];
                int n7 = this.rows / n;
                for (int i = 0; i < n; ++i) {
                    final int n8 = i * n7;
                    final int n9 = i == n - 1 ? this.rows : n8 + n7;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n6 + n8 * DenseFloatMatrix2D.this.rowStride;
                            for (int i = n8; i < n9; ++i) {
                                float[] fArray2 = fArray[i];
                                if (fArray2.length != DenseFloatMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray2.length + "columns()=" + DenseFloatMatrix2D.this.columns());
                                }
                                int n2 = n;
                                for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                    DenseFloatMatrix2D.this.elements[n2] = fArray2[j];
                                    n2 += DenseFloatMatrix2D.this.columnStride;
                                }
                                n += DenseFloatMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n6;
                for (int i = 0; i < this.rows; ++i) {
                    float[] fArray3 = fArray[i];
                    if (fArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + fArray3.length + "columns()=" + this.columns());
                    }
                    int n11 = n10;
                    for (int j = 0; j < this.columns; ++j) {
                        this.elements[n11] = fArray3[j];
                        n11 += this.columnStride;
                    }
                    n10 += this.rowStride;
                }
            }
            return this;
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D) {
        Object object;
        if (!(floatMatrix2D instanceof DenseFloatMatrix2D)) {
            super.assign(floatMatrix2D);
            return this;
        }
        DenseFloatMatrix2D denseFloatMatrix2D = (DenseFloatMatrix2D)floatMatrix2D;
        if (denseFloatMatrix2D == this) {
            return this;
        }
        this.checkShape(denseFloatMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseFloatMatrix2D.isNoView) {
            System.arraycopy(denseFloatMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseFloatMatrix2D)) {
            object = denseFloatMatrix2D.copy();
            if (!(object instanceof DenseFloatMatrix2D)) {
                super.assign(denseFloatMatrix2D);
                return this;
            }
            denseFloatMatrix2D = (DenseFloatMatrix2D)object;
        }
        object = denseFloatMatrix2D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n2 = (int)denseFloatMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        int n4 = denseFloatMatrix2D.columnStride;
        final int n5 = denseFloatMatrix2D.rowStride;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n6 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((float[])object, n4){
                    final /* synthetic */ float[] val$elementsOther;
                    final /* synthetic */ int val$columnStrideOther;
                    {
                        this.val$elementsOther = fArray;
                        this.val$columnStrideOther = n6;
                    }

                    public void run() {
                        int n = n3 + n7 * DenseFloatMatrix2D.this.rowStride;
                        int n22 = n2 + n7 * n5;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n;
                            int n4 = n22;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                DenseFloatMatrix2D.this.elements[n32] = this.val$elementsOther[n4];
                                n32 += DenseFloatMatrix2D.this.columnStride;
                                n4 += this.val$columnStrideOther;
                            }
                            n += DenseFloatMatrix2D.this.rowStride;
                            n22 += n5;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3;
            int n10 = n2;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n11] = (float)object[n12];
                    n11 += this.columnStride;
                    n12 += n4;
                }
                n9 += this.rowStride;
                n10 += n5;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction) {
        if (!(floatMatrix2D instanceof DenseFloatMatrix2D)) {
            super.assign(floatMatrix2D, floatFloatFunction);
            return this;
        }
        DenseFloatMatrix2D denseFloatMatrix2D = (DenseFloatMatrix2D)floatMatrix2D;
        this.checkShape(floatMatrix2D);
        final float[] fArray = denseFloatMatrix2D.elements;
        if (this.elements == null || fArray == null) {
            throw new InternalError();
        }
        final int n = (int)denseFloatMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseFloatMatrix2D.columnStride;
        final int n4 = denseFloatMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            float f;
            if (floatFloatFunction instanceof FloatPlusMultSecond && (f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator) == 0.0f) {
                return this;
            }
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (floatFloatFunction == FloatFunctions.mult) {
                            int n25 = n2 + n7 * DenseFloatMatrix2D.this.rowStride;
                            int n26 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n32 = n25;
                                int n42 = n26;
                                for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                    int n5 = n32;
                                    DenseFloatMatrix2D.this.elements[n5] = DenseFloatMatrix2D.this.elements[n5] * fArray[n42];
                                    n32 += DenseFloatMatrix2D.this.columnStride;
                                    n42 += n3;
                                }
                                n25 += DenseFloatMatrix2D.this.rowStride;
                                n26 += n4;
                            }
                        } else if (floatFloatFunction == FloatFunctions.div) {
                            int n27 = n2 + n7 * DenseFloatMatrix2D.this.rowStride;
                            int n6 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n72 = n27;
                                int n82 = n6;
                                for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                    int n9 = n72;
                                    DenseFloatMatrix2D.this.elements[n9] = DenseFloatMatrix2D.this.elements[n9] / fArray[n82];
                                    n72 += DenseFloatMatrix2D.this.columnStride;
                                    n82 += n3;
                                }
                                n27 += DenseFloatMatrix2D.this.rowStride;
                                n6 += n4;
                            }
                        } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
                            float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
                            if (f == 1.0f) {
                                int n28 = n2 + n7 * DenseFloatMatrix2D.this.rowStride;
                                int n10 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n11 = n28;
                                    int n12 = n10;
                                    for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                        int n13 = n11;
                                        DenseFloatMatrix2D.this.elements[n13] = DenseFloatMatrix2D.this.elements[n13] + fArray[n12];
                                        n11 += DenseFloatMatrix2D.this.columnStride;
                                        n12 += n3;
                                    }
                                    n28 += DenseFloatMatrix2D.this.rowStride;
                                    n10 += n4;
                                }
                            } else if (f == -1.0f) {
                                int n29 = n2 + n7 * DenseFloatMatrix2D.this.rowStride;
                                int n14 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n15 = n29;
                                    int n16 = n14;
                                    for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                        int n17 = n15;
                                        DenseFloatMatrix2D.this.elements[n17] = DenseFloatMatrix2D.this.elements[n17] - fArray[n16];
                                        n15 += DenseFloatMatrix2D.this.columnStride;
                                        n16 += n3;
                                    }
                                    n29 += DenseFloatMatrix2D.this.rowStride;
                                    n14 += n4;
                                }
                            } else {
                                int n30 = n2 + n7 * DenseFloatMatrix2D.this.rowStride;
                                int n18 = n + n7 * n4;
                                for (int i = n7; i < n8; ++i) {
                                    int n19 = n30;
                                    int n20 = n18;
                                    for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                        int n21 = n19;
                                        DenseFloatMatrix2D.this.elements[n21] = DenseFloatMatrix2D.this.elements[n21] + f * fArray[n20];
                                        n19 += DenseFloatMatrix2D.this.columnStride;
                                        n20 += n3;
                                    }
                                    n30 += DenseFloatMatrix2D.this.rowStride;
                                    n18 += n4;
                                }
                            }
                        } else {
                            int n31 = n2 + n7 * DenseFloatMatrix2D.this.rowStride;
                            int n22 = n + n7 * n4;
                            for (int i = n7; i < n8; ++i) {
                                int n23 = n31;
                                int n24 = n22;
                                for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                    DenseFloatMatrix2D.this.elements[n23] = floatFloatFunction.apply(DenseFloatMatrix2D.this.elements[n23], fArray[n24]);
                                    n23 += DenseFloatMatrix2D.this.columnStride;
                                    n24 += n3;
                                }
                                n31 += DenseFloatMatrix2D.this.rowStride;
                                n22 += n4;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else if (floatFloatFunction == FloatFunctions.mult) {
            int n9 = n2;
            int n10 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                for (int j = 0; j < this.columns; ++j) {
                    int n13 = n11;
                    this.elements[n13] = this.elements[n13] * fArray[n12];
                    n11 += this.columnStride;
                    n12 += n3;
                }
                n9 += this.rowStride;
                n10 += n4;
            }
        } else if (floatFloatFunction == FloatFunctions.div) {
            int n14 = n2;
            int n15 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n16 = n14;
                int n17 = n15;
                for (int j = 0; j < this.columns; ++j) {
                    int n18 = n16;
                    this.elements[n18] = this.elements[n18] / fArray[n17];
                    n16 += this.columnStride;
                    n17 += n3;
                }
                n14 += this.rowStride;
                n15 += n4;
            }
        } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
            float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
            if (f == 0.0f) {
                return this;
            }
            if (f == 1.0f) {
                int n19 = n2;
                int n20 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n21 = n19;
                    int n22 = n20;
                    for (int j = 0; j < this.columns; ++j) {
                        int n23 = n21;
                        this.elements[n23] = this.elements[n23] + fArray[n22];
                        n21 += this.columnStride;
                        n22 += n3;
                    }
                    n19 += this.rowStride;
                    n20 += n4;
                }
            } else if (f == -1.0f) {
                int n24 = n2;
                int n25 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n26 = n24;
                    int n27 = n25;
                    for (int j = 0; j < this.columns; ++j) {
                        int n28 = n26;
                        this.elements[n28] = this.elements[n28] - fArray[n27];
                        n26 += this.columnStride;
                        n27 += n3;
                    }
                    n24 += this.rowStride;
                    n25 += n4;
                }
            } else {
                int n29 = n2;
                int n30 = n;
                for (int i = 0; i < this.rows; ++i) {
                    int n31 = n29;
                    int n32 = n30;
                    for (int j = 0; j < this.columns; ++j) {
                        int n33 = n31;
                        this.elements[n33] = this.elements[n33] + f * fArray[n32];
                        n31 += this.columnStride;
                        n32 += n3;
                    }
                    n29 += this.rowStride;
                    n30 += n4;
                }
            }
        } else {
            int n34 = n2;
            int n35 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n36 = n34;
                int n37 = n35;
                for (int j = 0; j < this.columns; ++j) {
                    this.elements[n36] = floatFloatFunction.apply(this.elements[n36], fArray[n37]);
                    n36 += this.columnStride;
                    n37 += n3;
                }
                n34 += this.rowStride;
                n35 += n4;
            }
        }
        return this;
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, final FloatFloatFunction floatFloatFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(floatMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final float[] fArray = (float[])floatMatrix2D.elements();
        final int n2 = (int)floatMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = floatMatrix2D.columnStride();
        final int n5 = floatMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.rows);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n = n3 + nArray[i] * DenseFloatMatrix2D.this.rowStride + nArray2[i] * DenseFloatMatrix2D.this.columnStride;
                            int n22 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                            DenseFloatMatrix2D.this.elements[n] = floatFloatFunction.apply(DenseFloatMatrix2D.this.elements[n], fArray[n22]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                int n10 = n3 + nArray[i] * this.rowStride + nArray2[i] * this.columnStride;
                int n11 = n2 + nArray[i] * n5 + nArray2[i] * n4;
                this.elements[n10] = floatFloatFunction.apply(this.elements[n10], fArray[n11]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.rows / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n2 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + n6 * DenseFloatMatrix2D.this.rowStride;
                        for (int i = n6; i < n7; ++i) {
                            int n32 = n2;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                if (DenseFloatMatrix2D.this.elements[n32] != 0.0f) {
                                    ++n;
                                }
                                n32 += DenseFloatMatrix2D.this.columnStride;
                            }
                            n2 += DenseFloatMatrix2D.this.rowStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3;
            for (int i = 0; i < this.rows; ++i) {
                int n9 = n8;
                for (int j = 0; j < this.columns; ++j) {
                    if (this.elements[n9] != 0.0f) {
                        ++n;
                    }
                    n9 += this.columnStride;
                }
                n8 += this.rowStride;
            }
        }
        return n;
    }

    public void dct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.forward(this.elements, bl);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.dct2.forward((float[])floatMatrix2D.elements(), bl);
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFloatMatrix1D)this.viewColumn(i)).dct(bl);
            }
        }
    }

    public void dctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).dct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).dct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.forward(this.elements);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.dht2.forward((float[])floatMatrix2D.elements());
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFloatMatrix1D)this.viewColumn(i)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dhtRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).dht();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).dht();
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.forward(this.elements, bl);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.dst2.forward((float[])floatMatrix2D.elements(), bl);
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFloatMatrix1D)this.viewColumn(i)).dst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).dst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).dst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realForward(this.elements);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.fft2.realForward((float[])floatMatrix2D.elements());
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction intIntFloatFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = n + n4 * DenseFloatMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                float f = DenseFloatMatrix2D.this.elements[n2];
                                if (f != 0.0f) {
                                    DenseFloatMatrix2D.this.elements[n2] = intIntFloatFunction.apply(i, j, f);
                                }
                                n2 += DenseFloatMatrix2D.this.columnStride;
                            }
                            n3 += DenseFloatMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    float f = this.elements[n7];
                    if (f != 0.0f) {
                        this.elements[n7] = intIntFloatFunction.apply(i, j, f);
                    }
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return this;
    }

    public DenseColumnFloatMatrix2D getColumnMajor() {
        DenseColumnFloatMatrix2D denseColumnFloatMatrix2D = new DenseColumnFloatMatrix2D(this.rows, this.columns);
        final int n = (int)denseColumnFloatMatrix2D.index(0, 0);
        final int n2 = denseColumnFloatMatrix2D.rowStride();
        final int n3 = denseColumnFloatMatrix2D.columnStride();
        final float[] fArray = denseColumnFloatMatrix2D.elements();
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.rows);
            Future[] futureArray = new Future[n5];
            int n6 = this.rows / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n5 - 1 ? this.rows : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n4 + (n7 - 1) * DenseFloatMatrix2D.this.rowStride;
                        int n22 = n + (n7 - 1) * n2;
                        for (int i = n7; i < n8; ++i) {
                            int n32 = n6;
                            int n42 = n22;
                            int n5 = 0;
                            while (i < DenseFloatMatrix2D.this.columns) {
                                fArray[n42] = DenseFloatMatrix2D.this.elements[n32];
                                n32 += DenseFloatMatrix2D.this.rowStride;
                                n42 += n2;
                                ++n5;
                            }
                            n6 += DenseFloatMatrix2D.this.columnStride;
                            n22 += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4;
            int n10 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n11 = n9;
                int n12 = n10;
                int n13 = 0;
                while (i < this.columns) {
                    fArray[n12] = this.elements[n11];
                    n11 += this.rowStride;
                    n12 += n2;
                    ++n13;
                }
                n9 += this.columnStride;
                n10 += n3;
            }
        }
        return denseColumnFloatMatrix2D;
    }

    public DenseFComplexMatrix2D getFft2() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        final float[] fArray = this.isNoView ? this.elements : (float[])this.copy().elements();
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] fArray2 = denseFComplexMatrix2D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(fArray, i * DenseFloatMatrix2D.this.columns, fArray2, i * DenseFloatMatrix2D.this.columns, DenseFloatMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(fArray, i * this.columns, fArray2, i * this.columns, this.columns);
            }
        }
        this.fft2.realForwardFull(fArray2);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public DenseFComplexMatrix2D getFftColumns() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseFComplexMatrix2D.viewColumn(i).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                denseFComplexMatrix2D.viewColumn(i).assign(((DenseFloatMatrix1D)this.viewColumn(i)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public DenseFComplexMatrix2D getFftRows() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseFComplexMatrix2D.viewRow(i).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).getFft());
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                denseFComplexMatrix2D.viewRow(i).assign(((DenseFloatMatrix1D)this.viewRow(i)).getFft());
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public DenseFComplexMatrix2D getIfft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] fArray = denseFComplexMatrix2D.elements();
        final float[] fArray2 = this.isNoView ? this.elements : (float[])this.copy().elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            System.arraycopy(fArray2, i * DenseFloatMatrix2D.this.columns, fArray, i * DenseFloatMatrix2D.this.columns, DenseFloatMatrix2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(fArray2, i * this.columns, fArray, i * this.columns, this.columns);
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(fArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public DenseFComplexMatrix2D getIfftColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseFComplexMatrix2D.viewColumn(i).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                denseFComplexMatrix2D.viewColumn(i).assign(((DenseFloatMatrix1D)this.viewColumn(i)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public DenseFComplexMatrix2D getIfftRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            denseFComplexMatrix2D.viewRow(i).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).getIfft(bl));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                denseFComplexMatrix2D.viewRow(i).assign(((DenseFloatMatrix1D)this.viewRow(i)).getIfft(bl));
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix2D;
    }

    public float[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.rows);
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float f = DenseFloatMatrix2D.this.elements[n3 + n7 * DenseFloatMatrix2D.this.rowStride];
                        int n = n7;
                        int n2 = 0;
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseFloatMatrix2D.this.columns; ++j) {
                                float f2 = DenseFloatMatrix2D.this.elements[n3 + i * DenseFloatMatrix2D.this.rowStride + j * DenseFloatMatrix2D.this.columnStride];
                                if (!(f < f2)) continue;
                                f = f2;
                                n = i;
                                n2 = j;
                            }
                            n32 = 0;
                        }
                        return new float[]{f, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f < fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n = (int)fArray[n5][1];
                    n2 = (int)fArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[n3];
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    float f2 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (!(f < f2)) continue;
                    f = f2;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new float[]{f, n, n2};
    }

    public float[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        float f = 0.0f;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.rows);
            Future[] futureArray = new Future[n4];
            float[][] fArray = new float[n4][2];
            int n6 = this.rows / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? this.rows : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = n7;
                        int n2 = 0;
                        float f = DenseFloatMatrix2D.this.elements[n3 + n7 * DenseFloatMatrix2D.this.rowStride];
                        int n32 = 1;
                        for (int i = n7; i < n8; ++i) {
                            for (int j = n32; j < DenseFloatMatrix2D.this.columns; ++j) {
                                float f2 = DenseFloatMatrix2D.this.elements[n3 + i * DenseFloatMatrix2D.this.rowStride + j * DenseFloatMatrix2D.this.columnStride];
                                if (!(f > f2)) continue;
                                f = f2;
                                n = i;
                                n2 = j;
                            }
                            n32 = 0;
                        }
                        return new float[]{f, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    fArray[n5] = (float[])futureArray[n5].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                n2 = (int)fArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (!(f > fArray[n5][0])) continue;
                    f = fArray[n5][0];
                    n = (int)fArray[n5][1];
                    n2 = (int)fArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[n3];
            int n9 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n9; j < this.columns; ++j) {
                    float f2 = this.elements[n3 + i * this.rowStride + j * this.columnStride];
                    if (!(f > f2)) continue;
                    f = f2;
                    n = i;
                    n2 = j;
                }
                n9 = 0;
            }
        }
        return new float[]{f, n, n2};
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                float f = this.elements[n2];
                if (f < 0.0f) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    floatArrayList.add(f);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                float f = this.elements[n2];
                if (f != 0.0f) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    floatArrayList.add(f);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, FloatArrayList floatArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        floatArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.rows; ++i) {
            int n2 = n;
            for (int j = 0; j < this.columns; ++j) {
                float f = this.elements[n2];
                if (f > 0.0f) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    floatArrayList.add(f);
                }
                n2 += this.columnStride;
            }
            n += this.rowStride;
        }
    }

    public float getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public void idct2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.inverse(this.elements, bl);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.dct2.inverse((float[])floatMatrix2D.elements(), bl);
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFloatMatrix1D)this.viewColumn(i)).idct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idctRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).idct(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).idct(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.inverse(this.elements, bl);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.dht2.inverse((float[])floatMatrix2D.elements(), bl);
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFloatMatrix1D)this.viewColumn(i)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idhtRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).idht(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).idht(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.inverse(this.elements, bl);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.dst2.inverse((float[])floatMatrix2D.elements(), bl);
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstColumns(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.columns : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(i)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.columns; ++i) {
                ((DenseFloatMatrix1D)this.viewColumn(i)).idst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idstRows(final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = this.rows / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(i)).idst(bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.rows; ++i) {
                ((DenseFloatMatrix1D)this.viewRow(i)).idst(bl);
            }
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft2(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realInverse(this.elements, bl);
        } else {
            FloatMatrix2D floatMatrix2D = this.copy();
            this.fft2.realInverse((float[])floatMatrix2D.elements(), bl);
            this.assign((float[])floatMatrix2D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public FloatMatrix2D like(int n, int n2) {
        return new DenseFloatMatrix2D(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return new DenseFloatMatrix1D(n);
    }

    public void setQuick(int n, int n2, float f) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = f;
    }

    public float[][] toArray() {
        final float[][] fArray = new float[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n - 1 ? this.rows : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + n4 * DenseFloatMatrix2D.this.rowStride;
                        for (int i = n4; i < n5; ++i) {
                            float[] fArray2 = fArray[i];
                            int n22 = n;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                fArray2[j] = DenseFloatMatrix2D.this.elements[n22];
                                n22 += DenseFloatMatrix2D.this.columnStride;
                            }
                            n += DenseFloatMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2;
            for (int i = 0; i < this.rows; ++i) {
                float[] fArray2 = fArray[i];
                int n7 = n6;
                for (int j = 0; j < this.columns; ++j) {
                    fArray2[j] = this.elements[n7];
                    n7 += this.columnStride;
                }
                n6 += this.rowStride;
            }
        }
        return fArray;
    }

    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D((int)this.size());
        final int n = (int)this.index(0, 0);
        final int n2 = (int)denseFloatMatrix1D.index(0);
        final int n3 = denseFloatMatrix1D.stride();
        final float[] fArray = denseFloatMatrix1D.elements();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            int n5 = this.columns / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? this.columns : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = 0;
                        int n22 = n2 + n6 * DenseFloatMatrix2D.this.rows;
                        for (int i = n6; i < n7; ++i) {
                            n4 = n + i * DenseFloatMatrix2D.this.columnStride;
                            for (int j = 0; j < DenseFloatMatrix2D.this.rows; ++j) {
                                fArray[n22] = DenseFloatMatrix2D.this.elements[n4];
                                n4 += DenseFloatMatrix2D.this.rowStride;
                                n22 += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8 = n;
            int n9 = n2;
            for (int i = 0; i < this.columns; ++i) {
                n8 = n + i * this.columnStride;
                for (int j = 0; j < this.rows; ++j) {
                    fArray[n9] = this.elements[n8];
                    n8 += this.rowStride;
                    n9 += n3;
                }
            }
        }
        return denseFloatMatrix1D;
    }

    public void zAssign8Neighbors(FloatMatrix2D floatMatrix2D, Float9Function float9Function) {
        if (!(floatMatrix2D instanceof DenseFloatMatrix2D)) {
            super.zAssign8Neighbors(floatMatrix2D, float9Function);
            return;
        }
        if (float9Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(floatMatrix2D);
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        DenseFloatMatrix2D denseFloatMatrix2D = (DenseFloatMatrix2D)floatMatrix2D;
        int n3 = this.rowStride;
        int n4 = denseFloatMatrix2D.rowStride;
        int n5 = this.columnStride;
        int n6 = denseFloatMatrix2D.columnStride;
        float[] fArray = this.elements;
        float[] fArray2 = denseFloatMatrix2D.elements;
        if (fArray == null || fArray2 == null) {
            throw new InternalError();
        }
        int n7 = (int)this.index(1, 1);
        int n8 = (int)denseFloatMatrix2D.index(1, 1);
        for (int i = 1; i < n; ++i) {
            int n9 = n8;
            int n10 = n7 - n3 - n5;
            int n11 = n10 + n3;
            int n12 = n11 + n3;
            float f = fArray[n10];
            float f2 = fArray[n10 += n5];
            float f3 = fArray[n11];
            float f4 = fArray[n11 += n5];
            float f5 = fArray[n12];
            float f6 = fArray[n12 += n5];
            for (int j = 1; j < n2; ++j) {
                float f7 = fArray[n10 += n5];
                float f8 = fArray[n11 += n5];
                float f9 = fArray[n12 += n5];
                fArray2[n9] = float9Function.apply(f, f2, f7, f3, f4, f8, f5, f6, f9);
                n9 += n6;
                f = f2;
                f2 = f7;
                f3 = f4;
                f4 = f8;
                f5 = f6;
                f6 = f9;
            }
            n7 += n3;
            n8 += n4;
        }
    }

    public FloatMatrix1D zMult(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2, final float f, final float f2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(floatMatrix1D, floatMatrix1D2, f, f2, false);
        }
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = new DenseFloatMatrix1D(this.rows);
        }
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D) || !(floatMatrix1D2 instanceof DenseFloatMatrix1D)) {
            return super.zMult(floatMatrix1D, floatMatrix1D2, f, f2, bl);
        }
        if ((long)this.columns != floatMatrix1D.size() || (long)this.rows > floatMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + floatMatrix1D.toStringShort() + ", " + floatMatrix1D2.toStringShort());
        }
        final float[] fArray = (float[])floatMatrix1D.elements();
        final float[] fArray2 = (float[])floatMatrix1D2.elements();
        if (this.elements == null || fArray == null || fArray2 == null) {
            throw new InternalError();
        }
        final int n = floatMatrix1D.stride();
        final int n2 = floatMatrix1D2.stride();
        final int n3 = (int)this.index(0, 0);
        final int n4 = (int)floatMatrix1D.index(0);
        final int n5 = (int)floatMatrix1D2.index(0);
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.rows);
            Future[] futureArray = new Future[n6];
            int n7 = this.rows / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? this.rows : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n3 + n8 * DenseFloatMatrix2D.this.rowStride;
                        int n22 = n5 + n8 * n2;
                        for (int i = n8; i < n9; ++i) {
                            float f3 = 0.0f;
                            int n32 = n6;
                            int n42 = n4;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                f3 += DenseFloatMatrix2D.this.elements[n32] * fArray[n42];
                                n32 += DenseFloatMatrix2D.this.columnStride;
                                n42 += n;
                            }
                            fArray2[n22] = f * f3 + f2 * fArray2[n22];
                            n6 += DenseFloatMatrix2D.this.rowStride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n3;
            int n11 = n5;
            for (int i = 0; i < this.rows; ++i) {
                float f3 = 0.0f;
                int n12 = n10;
                int n13 = n4;
                for (int j = 0; j < this.columns; ++j) {
                    f3 += this.elements[n12] * fArray[n13];
                    n12 += this.columnStride;
                    n13 += n;
                }
                fArray2[n11] = f * f3 + f2 * fArray2[n11];
                n10 += this.rowStride;
                n11 += n2;
            }
        }
        return floatMatrix1D2;
    }

    public FloatMatrix2D zMult(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, final float f, final float f2, final boolean bl, final boolean bl2) {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = floatMatrix2D.rows();
        int n5 = floatMatrix2D.columns();
        int n6 = bl ? n3 : n2;
        int n7 = n = bl2 ? n4 : n5;
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = new DenseFloatMatrix2D(n6, n);
        }
        if (bl) {
            return this.viewDice().zMult(floatMatrix2D, floatMatrix2D2, f, f2, false, bl2);
        }
        if (floatMatrix2D instanceof SparseFloatMatrix2D || floatMatrix2D instanceof SparseRCFloatMatrix2D) {
            if (floatMatrix2D2 == null) {
                return floatMatrix2D.zMult(this, null, f, f2, !bl2, true).viewDice();
            }
            floatMatrix2D.zMult(this, floatMatrix2D2.viewDice(), f, f2, !bl2, true);
            return floatMatrix2D2;
        }
        if (bl2) {
            return this.zMult(floatMatrix2D.viewDice(), floatMatrix2D2, f, f2, bl, false);
        }
        if (!(floatMatrix2D2 instanceof DenseFloatMatrix2D)) {
            return super.zMult(floatMatrix2D, floatMatrix2D2, f, f2, bl, bl2);
        }
        if (floatMatrix2D.rows() != n3) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + floatMatrix2D.toStringShort());
        }
        if (floatMatrix2D2.rows() != n2 || floatMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + floatMatrix2D.toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long l = 2L * (long)n2 * (long)n3 * (long)n5;
        int n8 = (int)Math.min(l / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean bl3 = n5 >= n8;
        int n9 = bl3 ? n5 : n2;
        n8 = Math.min(n9, n8);
        if (n8 < 2) {
            return this.zMultSequential(floatMatrix2D, floatMatrix2D2, f, f2, bl, bl2);
        }
        int n10 = n9 / n8;
        Future[] futureArray = new Future[n8];
        for (int i = 0; i < n8; ++i) {
            FloatMatrix2D floatMatrix2D3;
            FloatMatrix2D floatMatrix2D4;
            FloatMatrix2D floatMatrix2D5;
            int n11 = i * n10;
            if (i == n8 - 1) {
                n10 = n9 - n10 * i;
            }
            if (bl3) {
                floatMatrix2D5 = this;
                floatMatrix2D4 = floatMatrix2D.viewPart(0, n11, n3, n10);
                floatMatrix2D3 = floatMatrix2D2.viewPart(0, n11, n2, n10);
            } else {
                floatMatrix2D5 = this.viewPart(n11, 0, n10, n3);
                floatMatrix2D4 = floatMatrix2D;
                floatMatrix2D3 = floatMatrix2D2.viewPart(n11, 0, n10, n5);
            }
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseFloatMatrix2D)floatMatrix2D5).zMultSequential(floatMatrix2D4, floatMatrix2D3, f, f2, bl, bl2);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
        return floatMatrix2D2;
    }

    public float zSum() {
        float f = 0.0f;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = 0.0f;
                        int n3 = n + n5 * DenseFloatMatrix2D.this.rowStride;
                        for (int i = n5; i < n6; ++i) {
                            int n2 = n3;
                            for (int j = 0; j < DenseFloatMatrix2D.this.columns; ++j) {
                                f += DenseFloatMatrix2D.this.elements[n2];
                                n2 += DenseFloatMatrix2D.this.columnStride;
                            }
                            n3 += DenseFloatMatrix2D.this.rowStride;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    f += ((Float)futureArray[n3].get()).floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = n;
            for (int i = 0; i < this.rows; ++i) {
                int n8 = n7;
                for (int j = 0; j < this.columns; ++j) {
                    f += this.elements[n8];
                    n8 += this.columnStride;
                }
                n7 += this.rowStride;
            }
        }
        return f;
    }

    private FloatMatrix2D zMultSequential(FloatMatrix2D floatMatrix2D, FloatMatrix2D floatMatrix2D2, float f, float f2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(floatMatrix2D, floatMatrix2D2, f, f2, false, bl2);
        }
        if (floatMatrix2D instanceof SparseFloatMatrix2D || floatMatrix2D instanceof SparseRCFloatMatrix2D || floatMatrix2D instanceof SparseCCFloatMatrix2D) {
            if (floatMatrix2D2 == null) {
                return floatMatrix2D.zMult(this, null, f, f2, !bl2, true).viewDice();
            }
            floatMatrix2D.zMult(this, floatMatrix2D2.viewDice(), f, f2, !bl2, true);
            return floatMatrix2D2;
        }
        if (bl2) {
            return this.zMult(floatMatrix2D.viewDice(), floatMatrix2D2, f, f2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = floatMatrix2D.columns();
        if (floatMatrix2D2 == null) {
            floatMatrix2D2 = new DenseFloatMatrix2D(n, n3);
        }
        if (!(floatMatrix2D instanceof DenseFloatMatrix2D) || !(floatMatrix2D2 instanceof DenseFloatMatrix2D)) {
            return super.zMult(floatMatrix2D, floatMatrix2D2, f, f2, bl, bl2);
        }
        if (floatMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + floatMatrix2D.toStringShort());
        }
        if (floatMatrix2D2.rows() != n || floatMatrix2D2.columns() != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + floatMatrix2D.toStringShort() + ", " + floatMatrix2D2.toStringShort());
        }
        if (this == floatMatrix2D2 || floatMatrix2D == floatMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseFloatMatrix2D denseFloatMatrix2D = (DenseFloatMatrix2D)floatMatrix2D;
        DenseFloatMatrix2D denseFloatMatrix2D2 = (DenseFloatMatrix2D)floatMatrix2D2;
        float[] fArray = this.elements;
        float[] fArray2 = denseFloatMatrix2D.elements;
        float[] fArray3 = denseFloatMatrix2D2.elements;
        if (fArray == null || fArray2 == null || fArray3 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseFloatMatrix2D.columnStride;
        int n6 = denseFloatMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseFloatMatrix2D.rowStride;
        int n9 = denseFloatMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = (int)denseFloatMatrix2D.index(0, 0);
            int n14 = (int)this.index(n12, 0);
            int n15 = (int)denseFloatMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    int n20 = n17;
                    int n21 = n13;
                    float f3 = 0.0f;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        f3 += fArray[n20 += n4] * fArray2[n21 += n8];
                    }
                    n22 = n2 / 4;
                    while (--n22 >= 0) {
                        int n23 = n20 + n4;
                        n20 = n23;
                        int n24 = n21 + n8;
                        n21 = n24;
                        int n25 = n20 + n4;
                        n20 = n25;
                        int n26 = n21 + n8;
                        n21 = n26;
                        n20 = n20 + n4;
                        n21 = n21 + n8;
                        f3 += fArray[n23] * fArray2[n24] + fArray[n25] * fArray2[n26] + fArray[n20] * fArray2[n21] + fArray[n20 += n4] * fArray2[n21 += n8];
                    }
                    fArray3[n18] = f * f3 + f2 * fArray3[n18];
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return floatMatrix2D2;
    }

    protected boolean haveSharedCellsRaw(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D instanceof SelectedDenseFloatMatrix2D) {
            SelectedDenseFloatMatrix2D selectedDenseFloatMatrix2D = (SelectedDenseFloatMatrix2D)floatMatrix2D;
            return this.elements == selectedDenseFloatMatrix2D.elements;
        }
        if (floatMatrix2D instanceof DenseFloatMatrix2D) {
            DenseFloatMatrix2D denseFloatMatrix2D = (DenseFloatMatrix2D)floatMatrix2D;
            return this.elements == denseFloatMatrix2D.elements;
        }
        return false;
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        return new DenseFloatMatrix1D(n, this.elements, n2, n3, true);
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseFloatMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

