/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.WrapperFloatMatrix2D;

class DelegateFloatMatrix2D
extends FloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FloatMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateFloatMatrix2D(FloatMatrix3D floatMatrix3D, int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= floatMatrix3D.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(floatMatrix3D.rows(), floatMatrix3D.columns());
                break;
            }
            case 1: {
                if (n2 < 0 || n2 >= floatMatrix3D.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(floatMatrix3D.slices(), floatMatrix3D.columns());
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= floatMatrix3D.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(floatMatrix3D.slices(), floatMatrix3D.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = n;
        this.index = n2;
        this.content = floatMatrix3D;
    }

    public synchronized float getQuick(int n, int n2) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, n, n2);
            }
            case 1: {
                return this.content.getQuick(n, this.index, n2);
            }
            case 2: {
                return this.content.getQuick(n, n2, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public FloatMatrix2D like(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, float f) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, n, n2, f);
                break;
            }
            case 1: {
                this.content.setQuick(n, this.index, n2, f);
                break;
            }
            case 2: {
                this.content.setQuick(n, n2, this.index, f);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public FloatMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        return new WrapperFloatMatrix2D(this).viewColumn(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    public FloatMatrix1D like1D(int n) {
        throw new InternalError();
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D(this.rows * this.columns);
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                ((FloatMatrix1D)denseFloatMatrix1D).setQuick(n++, this.getQuick(j, i));
            }
        }
        return denseFloatMatrix1D;
    }
}

