/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseFComplexMatrix2D(int n, int n2, ConcurrentHashMap<Long, float[]> concurrentHashMap, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = concurrentHashMap;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    protected SelectedSparseFComplexMatrix2D(ConcurrentHashMap<Long, float[]> concurrentHashMap, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, concurrentHashMap, 0, 0, 1, 1, nArray, nArray2, n);
    }

    @Override
    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    @Override
    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    @Override
    public float[] getQuick(int n, int n2) {
        return this.elements.get((long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride]);
    }

    @Override
    public ConcurrentHashMap<Integer, float[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D instanceof SelectedSparseFComplexMatrix2D) {
            SelectedSparseFComplexMatrix2D selectedSparseFComplexMatrix2D = (SelectedSparseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == selectedSparseFComplexMatrix2D.elements;
        }
        if (fComplexMatrix2D instanceof SparseFComplexMatrix2D) {
            SparseFComplexMatrix2D sparseFComplexMatrix2D = (SparseFComplexMatrix2D)fComplexMatrix2D;
            return this.elements == sparseFComplexMatrix2D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2) {
        return (long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    @Override
    public FComplexMatrix2D like(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix1D like1D(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    @Override
    protected FComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int n, int n2, float[] fArray) {
        long l = (long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, fArray);
        }
    }

    @Override
    public FComplexMatrix1D vectorize() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public void setQuick(int n, int n2, float f, float f2) {
        long l = (long)this.offset + (long)this.rowOffsets[this.rowZero + n * this.rowStride] + (long)this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new float[]{f, f2});
        }
    }

    @Override
    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    @Override
    public FComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedSparseFComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    @Override
    public FComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedSparseFComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseFComplexMatrix2D(this.elements, nArray, nArray2, this.offset);
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FloatMatrix2D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

