/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.Timer;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class BenchmarkSparseRCDoubleMatrix2D {
    private static final Timer t = new Timer();
    private static int niters = 200;
    private static int[] nthreads;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java cern.colt.matrix.tdouble.impl.BenchmarkSparseRCDoubleMatrix2D fileName nthreads1 [nthreads2 ... nthreadsn]");
            System.exit(-1);
        }
        nthreads = new int[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            BenchmarkSparseRCDoubleMatrix2D.nthreads[i - 1] = Integer.parseInt(stringArray[i]);
        }
        BenchmarkSparseRCDoubleMatrix2D.benchmarkZMult(stringArray[0]);
    }

    public static void benchmarkZMult(String string) {
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = null;
        File file = new File(string);
        try {
            sparseRCDoubleMatrix2D = new SparseDoubleMatrix2D(new MatrixVectorReader(new FileReader(file))).getRowCompressed(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Benchmark of SparseRCDoubleMatrix2D (" + file.getName() + ")");
        int n = sparseRCDoubleMatrix2D.rows();
        int n2 = sparseRCDoubleMatrix2D.cardinality();
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.make(n, 1.0);
        for (int i = 0; i < nthreads.length; ++i) {
            ConcurrencyUtils.setNumberOfThreads(nthreads[i]);
            System.out.println("\tNumber of threads = " + nthreads[i]);
            DoubleMatrix1D doubleMatrix1D2 = sparseRCDoubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, false);
            doubleMatrix1D2 = sparseRCDoubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, false);
            t.reset().start();
            for (int j = 0; j < niters; ++j) {
                doubleMatrix1D2 = sparseRCDoubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, false);
            }
            t.stop();
            double d = (double)t.nanos() / 1000.0 / (double)niters;
            System.out.println("\t\tAverage execution time of mat-vec-mult = " + t.millis() / (double)niters + " milliseconds");
            System.out.println("\t\tPerformance of mat-vec-mult = " + (double)(2 * n2) / d + " megaFLOPS");
            doubleMatrix1D2 = sparseRCDoubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, true);
            doubleMatrix1D2 = sparseRCDoubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, true);
            t.reset().start();
            for (int j = 0; j < niters; ++j) {
                doubleMatrix1D2 = sparseRCDoubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, true);
            }
            t.stop();
            d = (double)t.nanos() / 1000.0 / (double)niters;
            System.out.println("\t\tAverage execution time of mat-trans-vec-mult = " + t.millis() / (double)niters + " milliseconds");
            System.out.println("\t\tPerformance of mat-trans-vec-mult = " + (double)(2 * n2) / d + " megaFLOPS");
        }
    }
}

