/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdcomplex.impl.DelegateDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DiagonalDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix2D content;

    public WrapperDComplexMatrix2D(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D != null) {
            this.setUp(dComplexMatrix2D.rows(), dComplexMatrix2D.columns());
        }
        this.content = dComplexMatrix2D;
    }

    public DComplexMatrix2D assign(final double[] dArray) {
        if (this.content instanceof DiagonalDComplexMatrix2D) {
            int n = ((DiagonalDComplexMatrix2D)this.content).dlength;
            final double[] dArray2 = ((DiagonalDComplexMatrix2D)this.content).elements;
            if (dArray.length != 2 * n) {
                throw new IllegalArgumentException("Must have same length: length=" + dArray.length + " 2 * dlength=" + 2 * n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                dArray2[2 * i] = dArray[2 * i];
                                dArray2[2 * i + 1] = dArray[2 * i + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray2[2 * i] = dArray[2 * i];
                    dArray2[2 * i + 1] = dArray[2 * i + 1];
                }
            }
            return this;
        }
        return super.assign(dArray);
    }

    public DComplexMatrix2D assign(final float[] fArray) {
        if (this.content instanceof DiagonalDComplexMatrix2D) {
            int n = ((DiagonalDComplexMatrix2D)this.content).dlength;
            final double[] dArray = ((DiagonalDComplexMatrix2D)this.content).elements;
            if (fArray.length != 2 * n) {
                throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " 2 * dlength=" + 2 * n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                dArray[2 * i] = fArray[2 * i];
                                dArray[2 * i + 1] = fArray[2 * i + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray[2 * i] = fArray[2 * i];
                    dArray[2 * i + 1] = fArray[2 * i + 1];
                }
            }
            return this;
        }
        return super.assign(fArray);
    }

    public Object elements() {
        return this.content.elements();
    }

    public boolean equals(double[] dArray) {
        if (this.content instanceof DiagonalDComplexMatrix2D) {
            double d = DComplexProperty.DEFAULT.tolerance();
            double[] dArray2 = (double[])this.content.elements();
            int n = ((DiagonalDComplexMatrix2D)this.content).dlength;
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[2];
            for (int i = 0; i < n; ++i) {
                dArray3[0] = dArray2[2 * i];
                dArray3[1] = dArray2[2 * i + 1];
                dArray4[0] = Math.abs(dArray[0] - dArray3[0]);
                dArray4[1] = Math.abs(dArray[1] - dArray3[1]);
                if (!((dArray4[0] == dArray4[0] && dArray4[1] == dArray4[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1]) && !DComplex.isEqual(dArray, dArray3, d))) {
                    dArray4[0] = 0.0;
                    dArray4[1] = 0.0;
                }
                if (!(dArray4[0] > d) && !(dArray4[1] > d)) continue;
                return false;
            }
            return true;
        }
        return super.equals(dArray);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalDComplexMatrix2D && object instanceof DiagonalDComplexMatrix2D) {
            DiagonalDComplexMatrix2D diagonalDComplexMatrix2D = (DiagonalDComplexMatrix2D)object;
            int n = ((DiagonalDComplexMatrix2D)this.content).dlength;
            double d = DComplexProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalDComplexMatrix2D diagonalDComplexMatrix2D2 = (DiagonalDComplexMatrix2D)this.content;
            DiagonalDComplexMatrix2D diagonalDComplexMatrix2D3 = (DiagonalDComplexMatrix2D)object;
            if (diagonalDComplexMatrix2D2.columns() != diagonalDComplexMatrix2D3.columns() || diagonalDComplexMatrix2D2.rows() != diagonalDComplexMatrix2D3.rows() || diagonalDComplexMatrix2D2.diagonalIndex() != diagonalDComplexMatrix2D3.diagonalIndex() || diagonalDComplexMatrix2D2.diagonalLength() != diagonalDComplexMatrix2D3.diagonalLength()) {
                return false;
            }
            double[] dArray = diagonalDComplexMatrix2D.elements;
            double[] dArray2 = ((DiagonalDComplexMatrix2D)this.content).elements;
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[2];
            double[] dArray5 = new double[2];
            for (int i = 0; i < n; ++i) {
                dArray3[0] = dArray2[2 * i];
                dArray3[1] = dArray2[2 * i + 1];
                dArray4[0] = dArray[2 * i];
                dArray4[1] = dArray[2 * i + 1];
                dArray5[0] = Math.abs(dArray4[0] - dArray3[0]);
                dArray5[1] = Math.abs(dArray4[1] - dArray3[1]);
                if (!((dArray5[0] == dArray5[0] && dArray5[1] == dArray5[1] || dArray4[0] == dArray4[0] && dArray4[1] == dArray4[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1]) && !DComplex.isEqual(dArray4, dArray3, d))) {
                    dArray5[0] = 0.0;
                    dArray5[1] = 0.0;
                }
                if (!(dArray5[0] > d) && !(dArray5[1] > d)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public synchronized double[] getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public DComplexMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public DComplexMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public void fft2() {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).fft2();
            } else {
                DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = (DenseLargeDComplexMatrix2D)this.copy();
                denseLargeDComplexMatrix2D.fft2();
                this.assign(denseLargeDComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftColumns() {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).fftColumns();
            } else {
                DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = (DenseLargeDComplexMatrix2D)this.copy();
                denseLargeDComplexMatrix2D.fftColumns();
                this.assign(denseLargeDComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftRows() {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).fftRows();
            } else {
                DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = (DenseLargeDComplexMatrix2D)this.copy();
                denseLargeDComplexMatrix2D.fftRows();
                this.assign(denseLargeDComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftColumns(boolean bl) {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).ifftColumns(bl);
            } else {
                DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = (DenseLargeDComplexMatrix2D)this.copy();
                denseLargeDComplexMatrix2D.ifftColumns(bl);
                this.assign(denseLargeDComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftRows(boolean bl) {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).ifftRows(bl);
            } else {
                DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = (DenseLargeDComplexMatrix2D)this.copy();
                denseLargeDComplexMatrix2D.ifftRows(bl);
                this.assign(denseLargeDComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean bl) {
        if (this.content instanceof DenseLargeDComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix2D)this.content).ifft2(bl);
            } else {
                DenseLargeDComplexMatrix2D denseLargeDComplexMatrix2D = (DenseLargeDComplexMatrix2D)this.copy();
                denseLargeDComplexMatrix2D.ifft2(bl);
                this.assign(denseLargeDComplexMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized void setQuick(int n, int n2, double[] dArray) {
        this.content.setQuick(n, n2, dArray);
    }

    public synchronized void setQuick(int n, int n2, double d, double d2) {
        this.content.setQuick(n, n2, d, d2);
    }

    public DComplexMatrix1D vectorize() {
        final DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * WrapperDComplexMatrix2D.this.rows;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperDComplexMatrix2D.this.rows; ++j) {
                                denseDComplexMatrix1D.setQuick(n++, WrapperDComplexMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseDComplexMatrix1D.setQuick(n5++, this.getQuick(j, i));
                }
            }
        }
        return denseDComplexMatrix1D;
    }

    public DComplexMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public DComplexMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDComplexMatrix2D wrapperDComplexMatrix2D = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public synchronized void setQuick(int n, int n2, double[] dArray) {
                this.content.setQuick(n, this.columns - 1 - n2, dArray);
            }

            public synchronized void setQuick(int n, int n2, double d, double d2) {
                this.content.setQuick(n, this.columns - 1 - n2, d, d2);
            }

            public synchronized double[] get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public synchronized void set(int n, int n2, double[] dArray) {
                this.content.set(n, this.columns - 1 - n2, dArray);
            }

            public synchronized void set(int n, int n2, double d, double d2) {
                this.content.set(n, this.columns - 1 - n2, d, d2);
            }
        };
        wrapperDComplexMatrix2D.isNoView = false;
        return wrapperDComplexMatrix2D;
    }

    public DComplexMatrix2D viewDice() {
        WrapperDComplexMatrix2D wrapperDComplexMatrix2D = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public synchronized void setQuick(int n, int n2, double[] dArray) {
                this.content.setQuick(n2, n, dArray);
            }

            public synchronized void setQuick(int n, int n2, double d, double d2) {
                this.content.setQuick(n2, n, d, d2);
            }

            public synchronized double[] get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public synchronized void set(int n, int n2, double[] dArray) {
                this.content.set(n2, n, dArray);
            }

            public synchronized void set(int n, int n2, double d, double d2) {
                this.content.set(n2, n, d, d2);
            }
        };
        wrapperDComplexMatrix2D.rows = this.columns;
        wrapperDComplexMatrix2D.columns = this.rows;
        wrapperDComplexMatrix2D.isNoView = false;
        return wrapperDComplexMatrix2D;
    }

    public DComplexMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperDComplexMatrix2D wrapperDComplexMatrix2D = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public synchronized void setQuick(int n3, int n22, double[] dArray) {
                this.content.setQuick(n + n3, n2 + n22, dArray);
            }

            public synchronized void setQuick(int n3, int n22, double d, double d2) {
                this.content.setQuick(n + n3, n2 + n22, d, d2);
            }

            public synchronized double[] get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public synchronized void set(int n3, int n22, double[] dArray) {
                this.content.set(n + n3, n2 + n22, dArray);
            }

            public synchronized void set(int n3, int n22, double d, double d2) {
                this.content.set(n + n3, n2 + n22, d, d2);
            }
        };
        wrapperDComplexMatrix2D.rows = n3;
        wrapperDComplexMatrix2D.columns = n4;
        wrapperDComplexMatrix2D.isNoView = false;
        return wrapperDComplexMatrix2D;
    }

    public DComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateDComplexMatrix1D(this, n);
    }

    public DComplexMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDComplexMatrix2D wrapperDComplexMatrix2D = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public synchronized void setQuick(int n, int n2, double[] dArray) {
                this.content.setQuick(this.rows - 1 - n, n2, dArray);
            }

            public synchronized void setQuick(int n, int n2, double d, double d2) {
                this.content.setQuick(this.rows - 1 - n, n2, d, d2);
            }

            public synchronized double[] get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public synchronized void set(int n, int n2, double[] dArray) {
                this.content.set(this.rows - 1 - n, n2, dArray);
            }

            public synchronized void set(int n, int n2, double d, double d2) {
                this.content.set(this.rows - 1 - n, n2, d, d2);
            }
        };
        wrapperDComplexMatrix2D.isNoView = false;
        return wrapperDComplexMatrix2D;
    }

    public DComplexMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperDComplexMatrix2D wrapperDComplexMatrix2D = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public synchronized void setQuick(int n, int n2, double[] dArray) {
                this.content.setQuick(nArray3[n], nArray4[n2], dArray);
            }

            public synchronized void setQuick(int n, int n2, double d, double d2) {
                this.content.setQuick(nArray3[n], nArray4[n2], d, d2);
            }

            public synchronized double[] get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public synchronized void set(int n, int n2, double[] dArray) {
                this.content.set(nArray3[n], nArray4[n2], dArray);
            }

            public synchronized void set(int n, int n2, double d, double d2) {
                this.content.set(nArray3[n], nArray4[n2], d, d2);
            }
        };
        wrapperDComplexMatrix2D.rows = nArray.length;
        wrapperDComplexMatrix2D.columns = nArray2.length;
        wrapperDComplexMatrix2D.isNoView = false;
        return wrapperDComplexMatrix2D;
    }

    public DComplexMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDComplexMatrix2D wrapperDComplexMatrix2D = new WrapperDComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public synchronized void setQuick(int n3, int n22, double[] dArray) {
                this.content.setQuick(n * n3, n2 * n22, dArray);
            }

            public synchronized void setQuick(int n3, int n22, double d, double d2) {
                this.content.setQuick(n * n3, n2 * n22, d, d2);
            }

            public synchronized double[] get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public synchronized void set(int n3, int n22, double[] dArray) {
                this.content.set(n * n3, n2 * n22, dArray);
            }

            public synchronized void set(int n3, int n22, double d, double d2) {
                this.content.set(n * n3, n2 * n22, d, d2);
            }
        };
        if (this.rows != 0) {
            wrapperDComplexMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperDComplexMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        wrapperDComplexMatrix2D.isNoView = false;
        return wrapperDComplexMatrix2D;
    }

    protected DComplexMatrix2D getContent() {
        return this.content;
    }

    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    public DoubleMatrix2D getImaginaryPart() {
        final DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = new DenseLargeDoubleMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperDComplexMatrix2D.this.columns; ++j) {
                                denseLargeDoubleMatrix2D.setQuick(i, j, WrapperDComplexMatrix2D.this.getQuick(i, j)[1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    denseLargeDoubleMatrix2D.setQuick(i, j, this.getQuick(i, j)[1]);
                }
            }
        }
        return denseLargeDoubleMatrix2D;
    }

    public DoubleMatrix2D getRealPart() {
        final DenseLargeDoubleMatrix2D denseLargeDoubleMatrix2D = new DenseLargeDoubleMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperDComplexMatrix2D.this.columns; ++j) {
                                denseLargeDoubleMatrix2D.setQuick(i, j, WrapperDComplexMatrix2D.this.getQuick(i, j)[0]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    denseLargeDoubleMatrix2D.setQuick(i, j, this.getQuick(i, j)[0]);
                }
            }
        }
        return denseLargeDoubleMatrix2D;
    }
}

