/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseDComplexMatrix1D(int n, ConcurrentHashMap<Long, double[]> concurrentHashMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = concurrentHashMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected SelectedSparseDComplexMatrix1D(ConcurrentHashMap<Long, double[]> concurrentHashMap, int[] nArray) {
        this(nArray.length, concurrentHashMap, 0, 1, nArray, 0);
    }

    @Override
    protected int _offset(int n) {
        return this.offsets[n];
    }

    @Override
    public double[] getQuick(int n) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + n * this.stride]);
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D instanceof SelectedSparseDComplexMatrix1D) {
            SelectedSparseDComplexMatrix1D selectedSparseDComplexMatrix1D = (SelectedSparseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == selectedSparseDComplexMatrix1D.elements;
        }
        if (dComplexMatrix1D instanceof SparseDComplexMatrix1D) {
            SparseDComplexMatrix1D sparseDComplexMatrix1D = (SparseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == sparseDComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
    }

    @Override
    public DComplexMatrix1D like(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    @Override
    public DComplexMatrix2D like2D(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public DComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public void setQuick(int n, double[] dArray) {
        long l = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, dArray);
        }
    }

    @Override
    public void setQuick(int n, double d, double d2) {
        long l = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new double[]{d, d2});
        }
    }

    @Override
    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseDComplexMatrix1D(this.elements, nArray);
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

