/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

class SelectedDenseDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseDComplexMatrix2D(double[] dArray, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, dArray, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected SelectedDenseDComplexMatrix2D(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = dArray;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    public double[] getQuick(int n, int n2) {
        int n3 = this.rowZero + n * this.rowStride;
        int n4 = this.columnZero + n2 * this.columnStride;
        return new double[]{this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4]], this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4] + 1]};
    }

    public double[] elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D instanceof SelectedDenseDComplexMatrix2D) {
            SelectedDenseDComplexMatrix2D selectedDenseDComplexMatrix2D = (SelectedDenseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == selectedDenseDComplexMatrix2D.elements;
        }
        if (dComplexMatrix2D instanceof DenseDComplexMatrix2D) {
            DenseDComplexMatrix2D denseDComplexMatrix2D = (DenseDComplexMatrix2D)dComplexMatrix2D;
            return this.elements == denseDComplexMatrix2D.elements;
        }
        return false;
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public DComplexMatrix2D like(int n, int n2) {
        return new DenseDComplexMatrix2D(n, n2);
    }

    public DComplexMatrix1D like1D(int n) {
        return new DenseDComplexMatrix1D(n);
    }

    protected DComplexMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, double[] dArray) {
        int n3 = this.rowZero + n * this.rowStride;
        int n4 = this.columnZero + n2 * this.columnStride;
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4]] = dArray[0];
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4] + 1] = dArray[1];
    }

    public DComplexMatrix1D vectorize() {
        throw new IllegalAccessError("This method is not supported.");
    }

    public void setQuick(int n, int n2, double d, double d2) {
        int n3 = this.rowZero + n * this.rowStride;
        int n4 = this.columnZero + n2 * this.columnStride;
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4]] = d;
        this.elements[this.offset + this.rowOffsets[n3] + this.columnOffsets[n4] + 1] = d2;
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 2;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    public DComplexMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedDenseDComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public DComplexMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedDenseDComplexMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected DComplexMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseDComplexMatrix2D(this.elements, nArray, nArray2, this.offset);
    }

    public DoubleMatrix2D getRealPart() {
        final DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SelectedDenseDComplexMatrix2D.this.columns; ++j) {
                                double[] dArray = SelectedDenseDComplexMatrix2D.this.getQuick(i, j);
                                denseDoubleMatrix2D.setQuick(i, j, dArray[0]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double[] dArray = this.getQuick(i, j);
                    denseDoubleMatrix2D.setQuick(i, j, dArray[0]);
                }
            }
        }
        return denseDoubleMatrix2D;
    }

    public DoubleMatrix2D getImaginaryPart() {
        final DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < SelectedDenseDComplexMatrix2D.this.columns; ++j) {
                                double[] dArray = SelectedDenseDComplexMatrix2D.this.getQuick(i, j);
                                denseDoubleMatrix2D.setQuick(i, j, dArray[1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double[] dArray = this.getQuick(i, j);
                    denseDoubleMatrix2D.setQuick(i, j, dArray[1]);
                }
            }
        }
        return denseDoubleMatrix2D;
    }
}

