/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1DProcedure;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2DTest;
import cern.colt.matrix.tdcomplex.impl.DiagonalDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;

public class DiagonalDComplexMatrix2DTest
extends DComplexMatrix2DTest {
    protected int DLENGTH;
    protected int DINDEX;

    public DiagonalDComplexMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.DINDEX = 3;
        this.A = new DiagonalDComplexMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.B = new DiagonalDComplexMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.Bt = new DiagonalDComplexMatrix2D(this.NCOLUMNS, this.NROWS, -this.DINDEX);
        this.DLENGTH = ((DiagonalDComplexMatrix2D)this.A).diagonalLength();
    }

    protected void populateMatrices() {
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        if (this.DINDEX >= 0) {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n, n + this.DINDEX, Math.random(), Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n, n + this.DINDEX, Math.random(), Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n - this.DINDEX, n, Math.random(), Math.random());
            }
        } else {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n - this.DINDEX, n, Math.random(), Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n - this.DINDEX, n, Math.random(), Math.random());
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n, n + this.DINDEX, Math.random(), Math.random());
            }
        }
    }

    public void testAssignDoubleDouble() {
        double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.assign(dArray[0], dArray[1]);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                this.assertEquals(dArray, this.A.getQuick(i, i + this.DINDEX), this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                this.assertEquals(dArray, this.A.getQuick(i - this.DINDEX, i), this.TOL);
            }
        }
    }

    public void testAssignDoubleArray() {
        int n;
        double[] dArray = new double[2 * this.DLENGTH];
        for (n = 0; n < 2 * this.DLENGTH; ++n) {
            dArray[n] = Math.random();
        }
        this.A.assign(dArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[2 * n], (double)this.A.getQuick(n, n + this.DINDEX)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[2 * n + 1], (double)this.A.getQuick(n, n + this.DINDEX)[1], (double)this.TOL);
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[2 * n], (double)this.A.getQuick(n - this.DINDEX, n)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[2 * n + 1], (double)this.A.getQuick(n - this.DINDEX, n)[1], (double)this.TOL);
            }
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[2 * this.DLENGTH];
        for (n = 0; n < 2 * this.DLENGTH; ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)fArray[2 * n], (double)this.A.getQuick(n, n + this.DINDEX)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)fArray[2 * n + 1], (double)this.A.getQuick(n, n + this.DINDEX)[1], (double)this.TOL);
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)fArray[2 * n], (double)this.A.getQuick(n - this.DINDEX, n)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)fArray[2 * n + 1], (double)this.A.getQuick(n - this.DINDEX, n)[1], (double)this.TOL);
            }
        }
    }

    public void testAssignImaginary() {
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.random(this.A.rows(), this.A.columns());
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assignImaginary(doubleMatrix2D);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dComplexMatrix2D.getQuick(i, i + this.DINDEX)[0], (double)this.A.getQuick(i, i + this.DINDEX)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, i + this.DINDEX), (double)this.A.getQuick(i, i + this.DINDEX)[1], (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dComplexMatrix2D.getQuick(i - this.DINDEX, i)[0], (double)this.A.getQuick(i - this.DINDEX, i)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i - this.DINDEX, i), (double)this.A.getQuick(i - this.DINDEX, i)[1], (double)this.TOL);
            }
        }
    }

    public void testAssignReal() {
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.random(this.A.rows(), this.A.columns());
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assignReal(doubleMatrix2D);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dComplexMatrix2D.getQuick(i, i + this.DINDEX)[1], (double)this.A.getQuick(i, i + this.DINDEX)[1], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, i + this.DINDEX), (double)this.A.getQuick(i, i + this.DINDEX)[0], (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dComplexMatrix2D.getQuick(i - this.DINDEX, i)[1], (double)this.A.getQuick(i - this.DINDEX, i)[1], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i - this.DINDEX, i), (double)this.A.getQuick(i - this.DINDEX, i)[0], (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleArrayArray() {
        int n;
        double[][] dArray = new double[this.NROWS][2 * this.NCOLUMNS];
        for (n = 0; n < this.NROWS; ++n) {
            for (int i = 0; i < this.NCOLUMNS; ++i) {
                dArray[n][2 * i] = Math.random();
                dArray[n][2 * i + 1] = Math.random();
            }
        }
        this.A.assign(dArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[n][2 * (n + this.DINDEX)], (double)this.A.getQuick(n, n + this.DINDEX)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[n][2 * (n + this.DINDEX) + 1], (double)this.A.getQuick(n, n + this.DINDEX)[1], (double)this.TOL);
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[n - this.DINDEX][2 * n], (double)this.A.getQuick(n - this.DINDEX, n)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[n - this.DINDEX][2 * n + 1], (double)this.A.getQuick(n - this.DINDEX, n)[1], (double)this.TOL);
            }
        }
    }

    public void testAssignComplexComplexFunction() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assign(DComplexFunctions.acos);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                double[] dArray = DComplex.acos(dComplexMatrix2D.getQuick(i, i + this.DINDEX));
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[0], (double)this.A.getQuick(i, i + this.DINDEX)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[1], (double)this.A.getQuick(i, i + this.DINDEX)[1], (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                double[] dArray = DComplex.acos(dComplexMatrix2D.getQuick(i - this.DINDEX, i));
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[0], (double)this.A.getQuick(i - this.DINDEX, i)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[1], (double)this.A.getQuick(i - this.DINDEX, i)[1], (double)this.TOL);
            }
        }
    }

    public void testAssignComplexMatrix2DComplexComplexComplexFunction() {
        DComplexMatrix2D dComplexMatrix2D = this.A.copy();
        this.A.assign(this.B, DComplexFunctions.div);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[0], (double)this.A.getQuick(i, i + this.DINDEX)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[1], (double)this.A.getQuick(i, i + this.DINDEX)[1], (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[0], (double)this.A.getQuick(i - this.DINDEX, i)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[1], (double)this.A.getQuick(i - this.DINDEX, i)[1], (double)this.TOL);
            }
        }
    }

    public void testAssignDComplexMatrix2DDComplexDComplexFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i);
                intArrayList2.add(i + this.DINDEX);
            }
            DComplexMatrix2D dComplexMatrix2D = this.A.copy();
            this.A.assign(this.B, DComplexFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[0], (double)this.A.getQuick(i, i + this.DINDEX)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i, i + this.DINDEX), this.B.getQuick(i, i + this.DINDEX))[1], (double)this.A.getQuick(i, i + this.DINDEX)[1], (double)this.TOL);
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i - this.DINDEX);
                intArrayList2.add(i);
            }
            DComplexMatrix2D dComplexMatrix2D = this.A.copy();
            this.A.assign(this.B, DComplexFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[0], (double)this.A.getQuick(i - this.DINDEX, i)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)DComplex.div(dComplexMatrix2D.getQuick(i - this.DINDEX, i), this.B.getQuick(i - this.DINDEX, i))[1], (double)this.A.getQuick(i - this.DINDEX, i)[1], (double)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DiagonalDComplexMatrix2DTest.assertEquals((int)this.DLENGTH, (int)n);
    }

    public void testGetNonZeros() {
        this.A.assign(0.0, 0.0);
        double[] dArray = new double[]{0.7, 0.8};
        double[] dArray2 = new double[]{0.1, 0.2};
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, dArray);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, dArray2);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            this.A.getNonZeros(intArrayList, intArrayList2, arrayList);
            DiagonalDComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalDComplexMatrix2DTest.assertEquals((int)2, (int)arrayList.size());
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            this.assertEquals(this.A.getQuick(intArrayList.get(0), intArrayList2.get(0)), arrayList.get(0), this.TOL);
            this.assertEquals(this.A.getQuick(intArrayList.get(1), intArrayList2.get(1)), arrayList.get(1), this.TOL);
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, dArray);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, dArray2);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            this.A.getNonZeros(intArrayList, intArrayList3, arrayList);
            DiagonalDComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalDComplexMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalDComplexMatrix2DTest.assertEquals((int)2, (int)arrayList.size());
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalDComplexMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            this.assertEquals(this.A.getQuick(intArrayList.get(0), intArrayList3.get(0)), arrayList.get(0), this.TOL);
            this.assertEquals(this.A.getQuick(intArrayList.get(1), intArrayList3.get(1)), arrayList.get(1), this.TOL);
        }
    }

    public void testToArray() {
        double[][] dArray = this.A.toArray();
        DiagonalDComplexMatrix2DTest.assertTrue((this.NROWS == dArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalDComplexMatrix2DTest.assertTrue((2 * this.NCOLUMNS == dArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[i][2 * j], (double)this.A.getQuick(i, j)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray[i][2 * j + 1], (double)this.A.getQuick(i, j)[1], (double)this.TOL);
            }
        }
    }

    public void testVectorize() {
        DComplexMatrix1D dComplexMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                this.assertEquals(this.A.getQuick(j, i), dComplexMatrix1D.getQuick(n++), this.TOL);
            }
        }
    }

    public void testViewColumn() {
        DComplexMatrix1D dComplexMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        DiagonalDComplexMatrix2DTest.assertEquals((long)this.NROWS, (long)dComplexMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            this.assertEquals(this.A.getQuick(i, this.NCOLUMNS / 2), dComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewColumnFlip() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewColumnFlip();
        DiagonalDComplexMatrix2DTest.assertEquals((long)this.A.size(), (long)dComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, this.NCOLUMNS - 1 - j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewDice() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewDice();
        DiagonalDComplexMatrix2DTest.assertEquals((int)this.NROWS, (int)dComplexMatrix2D.columns());
        DiagonalDComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)dComplexMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(i, j), dComplexMatrix2D.getQuick(j, i), this.TOL);
            }
        }
    }

    public void testViewPart() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        DiagonalDComplexMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)dComplexMatrix2D.rows());
        DiagonalDComplexMatrix2DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)dComplexMatrix2D.columns());
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewRow() {
        DComplexMatrix1D dComplexMatrix1D = this.A.viewRow(this.NROWS / 2);
        DiagonalDComplexMatrix2DTest.assertEquals((long)this.NCOLUMNS, (long)dComplexMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            this.assertEquals(this.A.getQuick(this.NROWS / 2, i), dComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewRowFlip() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewRowFlip();
        DiagonalDComplexMatrix2DTest.assertEquals((long)this.A.size(), (long)dComplexMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                this.assertEquals(this.A.getQuick(this.NROWS - 1 - i, j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewSelectionComplexMatrix1DProcedure() {
        final double[] dArray = new double[]{2.0, 3.0};
        this.A.assign(0.0, 0.0);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX, dArray);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, dArray);
            DComplexMatrix2D dComplexMatrix2D = this.A.viewSelection(new DComplexMatrix1DProcedure(){

                public boolean apply(DComplexMatrix1D dComplexMatrix1D) {
                    return DComplex.abs(DComplex.minus(dComplexMatrix1D.getQuick(DiagonalDComplexMatrix2DTest.this.NROWS / 4 + DiagonalDComplexMatrix2DTest.this.DINDEX), dArray)) < DiagonalDComplexMatrix2DTest.this.TOL;
                }
            });
            DiagonalDComplexMatrix2DTest.assertEquals((int)1, (int)dComplexMatrix2D.rows());
            DiagonalDComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)dComplexMatrix2D.columns());
            this.assertEquals(this.A.getQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX), dComplexMatrix2D.getQuick(0, this.NROWS / 4 + this.DINDEX), this.TOL);
        } else {
            this.A.setQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4, dArray);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, dArray);
            DComplexMatrix2D dComplexMatrix2D = this.A.viewSelection(new DComplexMatrix1DProcedure(){

                public boolean apply(DComplexMatrix1D dComplexMatrix1D) {
                    return DComplex.abs(DComplex.minus(dComplexMatrix1D.getQuick(DiagonalDComplexMatrix2DTest.this.NROWS / 4), dArray)) < DiagonalDComplexMatrix2DTest.this.TOL;
                }
            });
            DiagonalDComplexMatrix2DTest.assertEquals((int)1, (int)dComplexMatrix2D.rows());
            DiagonalDComplexMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)dComplexMatrix2D.columns());
            this.assertEquals(this.A.getQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4), dComplexMatrix2D.getQuick(0, this.NROWS / 4), this.TOL);
        }
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2, this.NROWS - 1};
        DComplexMatrix2D dComplexMatrix2D = this.A.viewSelection(nArray, nArray2);
        DiagonalDComplexMatrix2DTest.assertEquals((int)nArray.length, (int)dComplexMatrix2D.rows());
        DiagonalDComplexMatrix2DTest.assertEquals((int)nArray2.length, (int)dComplexMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                this.assertEquals(this.A.getQuick(nArray[i], nArray2[j]), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        DComplexMatrix2D dComplexMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < dComplexMatrix2D.rows(); ++i) {
            for (int j = 0; j < dComplexMatrix2D.columns(); ++j) {
                this.assertEquals(this.A.getQuick(i * n, j * n2), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testZMultDComplexMatrix2DDComplexMatrix2DDComplexDComplexBooleanBoolean() {
        int n;
        double[] dArray;
        int n2;
        int n3;
        double[] dArray2 = new double[]{3.0, 4.0};
        double[] dArray3 = new double[]{5.0, 6.0};
        DComplexMatrix2D dComplexMatrix2D = new DiagonalDComplexMatrix2D(this.NROWS, this.NROWS, 0);
        for (int i = 0; i < this.DLENGTH; ++i) {
            dComplexMatrix2D.setQuick(i, i, Math.random(), Math.random());
        }
        double[][] dArray4 = dComplexMatrix2D.toArray();
        dComplexMatrix2D = this.A.zMult(this.Bt, dComplexMatrix2D, dArray2, dArray3, false, false);
        double[] dArray5 = new double[2];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n2, n), this.Bt.getQuick(n, n3)));
                }
                dArray5[0] = dArray4[n2][2 * n3];
                dArray5[1] = dArray4[n2][2 * n3 + 1];
                dArray5 = DComplex.mult(dArray3, dArray5);
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0] + dArray5[0];
                dArray4[n2][2 * n3 + 1] = dArray[1] + dArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.Bt, dComplexMatrix2D, dArray2, dArray3, false, false);
        dArray4 = new double[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n2, n), this.Bt.getQuick(n, n3)));
                }
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0];
                dArray4[n2][2 * n3 + 1] = dArray[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = new DiagonalDComplexMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            dComplexMatrix2D.setQuick(n3, n3, Math.random(), Math.random());
        }
        dArray4 = dComplexMatrix2D.toArray();
        dComplexMatrix2D = this.A.zMult(this.B, dComplexMatrix2D, dArray2, dArray3, true, false);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NROWS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(DComplex.conj(this.A.getQuick(n, n2)), this.B.getQuick(n, n3)));
                }
                dArray5[0] = dArray4[n2][2 * n3];
                dArray5[1] = dArray4[n2][2 * n3 + 1];
                dArray5 = DComplex.mult(dArray3, dArray5);
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0] + dArray5[0];
                dArray4[n2][2 * n3 + 1] = dArray[1] + dArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.B, dComplexMatrix2D, dArray2, dArray3, true, false);
        dArray4 = new double[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NROWS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(DComplex.conj(this.A.getQuick(n, n2)), this.B.getQuick(n, n3)));
                }
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0];
                dArray4[n2][2 * n3 + 1] = dArray[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = new DiagonalDComplexMatrix2D(this.NROWS, this.NROWS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            dComplexMatrix2D.setQuick(n3, n3, Math.random(), Math.random());
        }
        dArray4 = dComplexMatrix2D.toArray();
        dComplexMatrix2D = this.A.zMult(this.B, dComplexMatrix2D, dArray2, dArray3, false, true);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n2, n), DComplex.conj(this.B.getQuick(n3, n))));
                }
                dArray5[0] = dArray4[n2][2 * n3];
                dArray5[1] = dArray4[n2][2 * n3 + 1];
                dArray5 = DComplex.mult(dArray3, dArray5);
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0] + dArray5[0];
                dArray4[n2][2 * n3 + 1] = dArray[1] + dArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.B, dComplexMatrix2D, dArray2, dArray3, false, true);
        dArray4 = new double[this.NROWS][2 * this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n2, n), DComplex.conj(this.B.getQuick(n3, n))));
                }
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0];
                dArray4[n2][2 * n3 + 1] = dArray[1];
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = new DiagonalDComplexMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            dComplexMatrix2D.setQuick(n3, n3, Math.random(), Math.random());
        }
        dArray4 = dComplexMatrix2D.toArray();
        dComplexMatrix2D = this.A.zMult(this.Bt, dComplexMatrix2D, dArray2, dArray3, true, true);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NROWS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(DComplex.conj(this.A.getQuick(n, n2)), DComplex.conj(this.Bt.getQuick(n3, n))));
                }
                dArray5[0] = dArray4[n2][2 * n3];
                dArray5[1] = dArray4[n2][2 * n3 + 1];
                dArray5 = DComplex.mult(dArray3, dArray5);
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0] + dArray5[0];
                dArray4[n2][2 * n3 + 1] = dArray[1] + dArray5[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
        dComplexMatrix2D = null;
        dComplexMatrix2D = this.A.zMult(this.Bt, dComplexMatrix2D, dArray2, dArray3, true, true);
        dArray4 = new double[this.NCOLUMNS][2 * this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                dArray = new double[2];
                for (n = 0; n < this.NROWS; ++n) {
                    dArray = DComplex.plus(dArray, DComplex.mult(this.A.getQuick(n, n2), this.Bt.getQuick(n3, n)));
                }
                dArray = DComplex.mult(dArray2, dArray);
                dArray4[n2][2 * n3] = dArray[0];
                dArray4[n2][2 * n3 + 1] = dArray[1];
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2], (double)dComplexMatrix2D.getQuick(n3, n2)[0], (double)this.TOL);
                DiagonalDComplexMatrix2DTest.assertEquals((double)dArray4[n3][2 * n2 + 1], (double)dComplexMatrix2D.getQuick(n3, n2)[1], (double)this.TOL);
            }
        }
    }
}

