/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tlong;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongProcedure;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractLongLongMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractLongLongMap() {
    }

    public void assign(final LongFunction longFunction) {
        this.copy().forEachPair(new LongLongProcedure(){

            public boolean apply(long l, long l2) {
                AbstractLongLongMap.this.put(l, longFunction.apply(l2));
                return true;
            }
        });
    }

    public void assign(AbstractLongLongMap abstractLongLongMap) {
        this.clear();
        abstractLongLongMap.forEachPair(new LongLongProcedure(){

            public boolean apply(long l, long l2) {
                AbstractLongLongMap.this.put(l, l2);
                return true;
            }
        });
    }

    public boolean containsKey(final long l) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long l2) {
                return l != l2;
            }
        });
    }

    public boolean containsValue(final long l) {
        return !this.forEachPair(new LongLongProcedure(){

            public boolean apply(long l3, long l2) {
                return l != l2;
            }
        });
    }

    public AbstractLongLongMap copy() {
        return (AbstractLongLongMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractLongLongMap)) {
            return false;
        }
        final AbstractLongLongMap abstractLongLongMap = (AbstractLongLongMap)object;
        if (abstractLongLongMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongLongProcedure(){

            public boolean apply(long l, long l2) {
                return abstractLongLongMap.containsKey(l) && abstractLongLongMap.get(l) == l2;
            }
        }) && abstractLongLongMap.forEachPair(new LongLongProcedure(){

            public boolean apply(long l, long l2) {
                return AbstractLongLongMap.this.containsKey(l) && AbstractLongLongMap.this.get(l) == l2;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongLongProcedure longLongProcedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                return longLongProcedure.apply(l, AbstractLongLongMap.this.get(l));
            }
        });
    }

    public abstract long get(long var1);

    public long keyOf(final long l) {
        final long[] lArray = new long[1];
        boolean bl = this.forEachPair(new LongLongProcedure(){

            public boolean apply(long l3, long l2) {
                boolean bl;
                boolean bl2 = bl = l == l2;
                if (bl) {
                    lArray[0] = l3;
                }
                return !bl;
            }
        });
        if (bl) {
            return Long.MIN_VALUE;
        }
        return lArray[0];
    }

    public LongArrayList keys() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.keys(longArrayList);
        return longArrayList;
    }

    public void keys(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                longArrayList.add(l);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList longArrayList) {
        this.pairsSortedByValue(longArrayList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final LongLongProcedure longLongProcedure, final LongArrayList longArrayList, final LongArrayList longArrayList2) {
        longArrayList.clear();
        longArrayList2.clear();
        this.forEachPair(new LongLongProcedure(){

            public boolean apply(long l, long l2) {
                if (longLongProcedure.apply(l, l2)) {
                    longArrayList.add(l);
                    longArrayList2.add(l2);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList longArrayList, LongArrayList longArrayList2) {
        this.keys(longArrayList);
        longArrayList.sort();
        longArrayList2.setSize(longArrayList.size());
        int n = longArrayList.size();
        while (--n >= 0) {
            longArrayList2.setQuick(n, this.get(longArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(LongArrayList longArrayList, LongArrayList longArrayList2) {
        this.keys(longArrayList);
        this.values(longArrayList2);
        final long[] lArray = longArrayList.elements();
        final long[] lArray2 = longArrayList2.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                long l = lArray2[n];
                lArray2[n] = lArray2[n2];
                lArray2[n2] = l;
                long l2 = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l2;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return lArray2[n] < lArray2[n2] ? -1 : (lArray2[n] > lArray2[n2] ? 1 : (lArray[n] < lArray[n2] ? -1 : (lArray[n] == lArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, longArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(long var1, long var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList longArrayList = this.keys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        LongArrayList longArrayList = new LongArrayList();
        this.keysSortedByValue(longArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public LongArrayList values() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.values(longArrayList);
        return longArrayList;
    }

    public void values(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                longArrayList.add(AbstractLongLongMap.this.get(l));
                return true;
            }
        });
    }
}

