/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tlong;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tint.IntProcedure;
import cern.colt.function.tlong.IntLongProcedure;
import cern.colt.function.tlong.LongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntLongMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractIntLongMap() {
    }

    public void assign(final LongFunction longFunction) {
        this.copy().forEachPair(new IntLongProcedure(){

            public boolean apply(int n, long l) {
                AbstractIntLongMap.this.put(n, longFunction.apply(l));
                return true;
            }
        });
    }

    public void assign(AbstractIntLongMap abstractIntLongMap) {
        this.clear();
        abstractIntLongMap.forEachPair(new IntLongProcedure(){

            public boolean apply(int n, long l) {
                AbstractIntLongMap.this.put(n, l);
                return true;
            }
        });
    }

    public boolean containsKey(final int n) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int n2) {
                return n != n2;
            }
        });
    }

    public boolean containsValue(final long l) {
        return !this.forEachPair(new IntLongProcedure(){

            public boolean apply(int n, long l2) {
                return l != l2;
            }
        });
    }

    public AbstractIntLongMap copy() {
        return (AbstractIntLongMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractIntLongMap)) {
            return false;
        }
        final AbstractIntLongMap abstractIntLongMap = (AbstractIntLongMap)object;
        if (abstractIntLongMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntLongProcedure(){

            public boolean apply(int n, long l) {
                return abstractIntLongMap.containsKey(n) && abstractIntLongMap.get(n) == l;
            }
        }) && abstractIntLongMap.forEachPair(new IntLongProcedure(){

            public boolean apply(int n, long l) {
                return AbstractIntLongMap.this.containsKey(n) && AbstractIntLongMap.this.get(n) == l;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntLongProcedure intLongProcedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                return intLongProcedure.apply(n, AbstractIntLongMap.this.get(n));
            }
        });
    }

    public abstract long get(int var1);

    public int keyOf(final long l) {
        final int[] nArray = new int[1];
        boolean bl = this.forEachPair(new IntLongProcedure(){

            public boolean apply(int n, long l2) {
                boolean bl;
                boolean bl2 = bl = l == l2;
                if (bl) {
                    nArray[0] = n;
                }
                return !bl;
            }
        });
        if (bl) {
            return Integer.MIN_VALUE;
        }
        return nArray[0];
    }

    public IntArrayList keys() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.keys(intArrayList);
        return intArrayList;
    }

    public void keys(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                intArrayList.add(n);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList intArrayList) {
        this.pairsSortedByValue(intArrayList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final IntLongProcedure intLongProcedure, final IntArrayList intArrayList, final LongArrayList longArrayList) {
        intArrayList.clear();
        longArrayList.clear();
        this.forEachPair(new IntLongProcedure(){

            public boolean apply(int n, long l) {
                if (intLongProcedure.apply(n, l)) {
                    intArrayList.add(n);
                    longArrayList.add(l);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList intArrayList, LongArrayList longArrayList) {
        this.keys(intArrayList);
        intArrayList.sort();
        longArrayList.setSize(intArrayList.size());
        int n = intArrayList.size();
        while (--n >= 0) {
            longArrayList.setQuick(n, this.get(intArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(IntArrayList intArrayList, LongArrayList longArrayList) {
        this.keys(intArrayList);
        this.values(longArrayList);
        final int[] nArray = intArrayList.elements();
        final long[] lArray = longArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return lArray[n] < lArray[n2] ? -1 : (lArray[n] > lArray[n2] ? 1 : (nArray[n] < nArray[n2] ? -1 : (nArray[n] == nArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, intArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(int var1, long var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList intArrayList = this.keys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        IntArrayList intArrayList = new IntArrayList();
        this.keysSortedByValue(intArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public LongArrayList values() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.values(longArrayList);
        return longArrayList;
    }

    public void values(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                longArrayList.add(AbstractIntLongMap.this.get(n));
                return true;
            }
        });
    }
}

